package com.zbkj.service.wangshang.api.domain.model;


import com.zbkj.service.wangshang.api.domain.RequestBody;
import com.zbkj.service.wangshang.api.internal.util.CDataAdapter;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 * 商户信息修改< ant.mybank.merchantprod.merch.updateMerchant>
 * <p>
 * 本接口提供商户信息补充/修改的服务。商户信息修改后会立即生效。
 *
 * 请求报文
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "body")
public class MerchantprodMerchUpdateMerchantRequestModel extends RequestBody {

    private static final long serialVersionUID = -3361228713305991148L;
    /**
     * 合作方机构号
     * <p>
     * 网商银行分配
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "IsvOrgId")
    private String isvOrgId;

    /**
     * 商户号。网商为商户分配的商户号，通过商户入驻结果查询接口获取
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "MerchantId")
    private String merchantId;

    /**
     * 商户经营类型   可选值：01:实体特约商户; 02:网络特约商户; 03:实体兼网络特约商户
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "DealType")
    private String dealType;

    /**
     * 商户详情列表
     * <p>
     * json格式base64编码，具体报文定义参考商户详情
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "MerchantDetail")
    private String merchantDetail;

    /**
     * 清算卡参数
     * <p>
     * json格式base64编码，具体报文定义参考下面的清算卡，仅结算方式为“01结算到他行卡”需要填写
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "BankCardParam")
    private String bankCardParam;

    /**
     * 外部交易号
     * <p>
     * 合作方系统生成的外部交易号，同一交易号被视为同一笔交易。
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "OutTradeNo")
    private String outTradeNo;

    /**
     * 经营类目
     * <p>
     * 参见附录的经营类目上送
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "Mcc")
    private String mcc;

    /**
     * 手机验证码
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "AuthCode")
    private String authCode;

    /**
     * 支持支付渠道列表
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "PayChannelList")
    private String payChannelList;

    /**
     * 直付通信息
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "ZftAlipayInfo")
    private String zftAlipayInfo;

    /**
     * 直付通开票信息
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "InvoiceInfo")
    private String invoiceInfo;

    public String getIsvOrgId() {
        return isvOrgId;
    }

    public void setIsvOrgId(String isvOrgId) {
        this.isvOrgId = isvOrgId;
    }

    public String getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getDealType() {
        return dealType;
    }

    public void setDealType(String dealType) {
        this.dealType = dealType;
    }

    public String getMerchantDetail() {
        return merchantDetail;
    }

    public void setMerchantDetail(String merchantDetail) {
        this.merchantDetail = merchantDetail;
    }

    public String getBankCardParam() {
        return bankCardParam;
    }

    public void setBankCardParam(String bankCardParam) {
        this.bankCardParam = bankCardParam;
    }

    public String getOutTradeNo() {
        return outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public String getMcc() {
        return mcc;
    }

    public void setMcc(String mcc) {
        this.mcc = mcc;
    }

    public String getAuthCode() {
        return authCode;
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public String getPayChannelList() { return payChannelList; }
    public void setPayChannelList(String payChannelList) { this.payChannelList = payChannelList; }

    public String getZftAlipayInfo() { return zftAlipayInfo; }
    public void setZftAlipayInfo(String zftAlipayInfo) { this.zftAlipayInfo = zftAlipayInfo; }

    public String getInvoiceInfo() { return invoiceInfo; }
    public void setInvoiceInfo(String invoiceInfo) { this.invoiceInfo = invoiceInfo; }
}