package com.zbkj.service.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.model.bcx.BcxProductBenefits;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.UserProductBenefitsRequest;
import com.zbkj.common.request.UserProductBenefitsSaveRequest;
import com.zbkj.common.response.UserProductBenefitsResponse;

import java.util.List;

/**
 * description：福利配置表 服务接口
 * author：linchunpeng
 * date：2024/1/26
 */
public interface BcxProductBenefitsService extends IService<BcxProductBenefits> {

    /**
     * 根据商品id，查询授权的企业列表
     */
    List<BcxProductBenefits> findListByProductId(Integer productId);

    /**
     * 根据企业id，查询授权的商品列表
     */
    List<BcxProductBenefits> findListByCompanyId(String companyId);

    PageInfo<UserProductBenefitsResponse> getPage(UserProductBenefitsRequest request,
                                                  PageParamRequest pageRequest);

    /**
     * description：分佣配置保存
     * author：linchunpeng
     * date：2024/5/10
     */
    Boolean saveConfig(UserProductBenefitsSaveRequest request);
}