/**
 * Copyright (c) 2011-2014, hubin (jobob@qq.com).
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.zbkj.service.wangshang.constants;


/**
 * <b> 汇付支付业务接口标识 </b>
 * @author ZXF
 * @create 2023/08/02 0002 16:37
 * @version
 * @注意事项 </b>
 */
public enum WSBusiCode {
	JSQUERY("V2MerchantBasicdataSettlementQuery", "结算记录查询"),
	CWQUERY("V2TradeAcctpaymentAcctlogQuery", "账务流水查询"),
	JYFZQUERY("V2TradeTransSplitQuery", "交易分账明细查询接口（废弃）"),
	YEQUERY("BkcloudfundsBalanceQueryRequest", "商户余额接口"),
	ZHYEQUERY("BkcloudfundsMerchantSceneBalanceQueryRequest", "账户余额信息查询接口"),
	YEPAY("V2TradeAcctpaymentPay", "余额支付"),
	YEPAYJG("BkcloudfundsProtocolWithholdQueryRequest", "余额支付结果"),
	YEUNFREEZE("MerchantAccountUnfreezeApply", "余额解冻"),
	TAUTHSTATUS("MerchantprodMerchantArrangementInfoQueryRequest", "协议代扣授权状态查询"),
	TAUTH("MerchantprodMerchantArrangeMentAuditRequest", "解约授权"),
	ZDCONFIG("V2MerchantBusiBillConfig", "交易结算对账单配置"),
	ZDREPLAY("V2TradeCheckReplay", "交易结算对账单重新生成"),
	ZDQUERY("V2TradeCheckFilequery", "交易结算对账单查询"),
	FEEFILEAPPLY("BkmbpStmtFeeFileApplyRequest", "手续费对账单文件申请"),
	FEEFILEQUERY("BkmbpStmtFeeFileApplyRequest", "手续费对账单文件查询"),
	TXQUERY("V2TradeBatchtranslogQuery", "批量出金交易查询"),
	WYPAY("V2TradeOnlinepaymentBankingFrontpay", "网银支付接口"),
	HDAPPLY("BkcloudfundsElectronicreceiptApplyRequest", "电子回单申请"),
	HDBATCHAPPLY("BkcloudfundsElectronicreceiptBatchApplyRequest", "汇总电子回单申请"),
	HDQUERY("BkcloudfundsElectronicreceiptQueryRequest", "电子回单查询"),
	ENCHASHMENT("BkcloudfundsWithdrawApplyRequest", "提现申请"),
	ENCHASHMENTCONFIRM("BkcloudfundsWithdrawApplyConfirmRequest", "提现确认"),
	UPLOAD("MerchantprodMerchantUploadphotoRequest", "图片上传接口"),
	ENT("MerchantprodMerchAppletPreRegisterRequest", "企业用户基本信息开户"),
	ENTMODIFY("MerchantprodMerchUpdateMerchantRequest", "企业用户基本信息修改"),
	SHRZQUERY("MerchantprodMerchRegisterQueryRequest", "商户入驻查询"),
	SHXGQUERY("MerchantprodMerchAsyncUpdateMerchantQueryRequest", "商户修改查询"),
	SHQUERY("MerchantprodMerchQueryRequest", "商户信息查询"),
	YHQUERY("MerchantprodMerchAppletRegisterQueryRequest", "用户信息查询"),
	YHACTIVE("YHACTIVE", "商户激活字段组装"),
	YHLOGIN("YHLOGIN", "商户登录小程序云资金"),
	ACTIVEQUERY("", "商户激活结果查询"),
	BUSIMODIFY("V2UserBusiModify", "用户业务入驻修改"),
	BUSIOPEN("V2UserBusiOpen", "用户业务入驻"),
	JSPAY("V2TradePaymentJspay", "聚合正扫"),
	SCANPAYQUERY("V2TradePaymentScanpayQuery", "交易查询接口"),
	SCANPAYREFUND("V2TradePaymentScanpayRefund", "扫码交易退款"),
	REFUNDQUERY("V2TradePaymentScanpayRefundquery", "交易退款查询接口"),
	XYREFUNDAPPLY("ProtocolWithholdRefundApplyRequest", "协议代扣退款申请"),
	XYREFUNDQUERY("V2TradePaymentScanpayRefundquery", "交易退款查询接口"),
	DKQUERY("BkcloudfundsProtocolWithholdQueryRequest", "交易代扣查询接口"),
	APQUERY("V2TradeAcctpaymentPayQuery", "余额支付查询"),
	BATCHQUERY("BkcloudfundsVostroChargeBatchQuery", "充值保证金查询"),
	REFUNDAPPLY("BkcloudfundsRefundApplyRequest", "支付退回申请"),
	BREFUNDQUERY("BkcloudfundsRefundQueryRequest", "支付退回查询");

	private final String cla;

	private final String desc;

	WSBusiCode(final String cla, final String desc) {
		this.cla = cla;
		this.desc = desc;
	}

	/**
	 * <p>
	 * 获取优化类型.如果没有找到默认null
	 * </p>
	 * 
	 * @param hFBusiCodeCla
	 *            优化方式
	 * @return
	 */
	public static WSBusiCode getHFBusiCodeCla(String hFBusiCodeCla) {
		for (WSBusiCode hFBusiCode : WSBusiCode.values()) {
			if (hFBusiCode.getCla().equalsIgnoreCase(hFBusiCodeCla)) {
				return hFBusiCode;
			}
		}
		return null;
	}

	public String getCla() {
		return this.cla;
	}

	public String getDesc() {
		return this.desc;
	}
}
