package com.zbkj.service.wangshang.api.domain.model;


import com.zbkj.service.wangshang.api.domain.RequestBody;
import com.zbkj.service.wangshang.api.internal.util.CDataAdapter;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 * 协议代扣退款结果查询接口<ant.mybank.bkcloudfunds.protocol.withhold.refund.query>
 * 请求模型
 * <p>
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "body")
public class ProtocolWithholdRefundQueryRequestModel extends RequestBody {
    private static final long serialVersionUID = -3173736557858816244L;

    /**
     * 合作方机构号（网商银行分配）
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "IsvOrgId")
    private String isvOrgId;

    /**
     * 关联网商订单号
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "RelateOrderNo")
    private String relateOrderNo;

    /**
     * 退款参与方类型 商户(MERCHANT)、 平台(PLATFORM)、子户汇入（SUBACCOUNT）
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "ParticipantType")
    private String participantType;

    /**
     * 退款参与方id
     * 如果是商户，则填入merchantId,
     * 如果是平台，则填入isvOrgId
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "ParticipantId")
    private String participantId;

    /**
     * 退款外部交易号
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "OutRefundNo")
    private String outRefundNo;

    /**
     * 网商退款订单号
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "RefundOrderNo")
    private String refundOrderNo;

    public String getIsvOrgId() {
        return isvOrgId;
    }

    public void setIsvOrgId(String isvOrgId) {
        this.isvOrgId = isvOrgId;
    }

    public String getRelateOrderNo() {
        return relateOrderNo;
    }

    public void setRelateOrderNo(String relateOrderNo) {
        this.relateOrderNo = relateOrderNo;
    }

    public String getParticipantType() {
        return participantType;
    }

    public void setParticipantType(String participantType) {
        this.participantType = participantType;
    }

    public String getParticipantId() {
        return participantId;
    }

    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    public String getOutRefundNo() {
        return outRefundNo;
    }

    public void setOutRefundNo(String outRefundNo) {
        this.outRefundNo = outRefundNo;
    }

    public String getRefundOrderNo() {
        return refundOrderNo;
    }

    public void setRefundOrderNo(String refundOrderNo) {
        this.refundOrderNo = refundOrderNo;
    }
}
