package com.zbkj.service.service.bcx;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.model.bcx.BcxOrderDeviceNo;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.bcx.BcxOrderDeviceNoRequest;
import com.zbkj.common.response.bcx.BcxOrderDeviceNoResponse;
import com.zbkj.service.dao.bcx.BcxOrderDeviceNoDao;
import com.zbkj.service.service.bcx.BcxOrderDeviceNoService;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import java.util.ArrayList;
import java.util.List;
/**
 * 订单设备编号 服务实现类
 */
@Service
public class BcxOrderDeviceNoServiceImpl extends ServiceImpl<BcxOrderDeviceNoDao, BcxOrderDeviceNo> implements BcxOrderDeviceNoService {

    @Resource
    private BcxOrderDeviceNoDao dao;

    @Override
    public BcxOrderDeviceNoResponse queryById(Integer id){
        BcxOrderDeviceNo source = dao.selectById(id);
        BcxOrderDeviceNoResponse target = transform(source);
        return target;
    }

    @Override
    public PageInfo<BcxOrderDeviceNoResponse> queryPagedList(BcxOrderDeviceNoRequest request,
                                                             PageParamRequest pageParamRequest){
        LambdaQueryWrapper<BcxOrderDeviceNo> lqw = new LambdaQueryWrapper<>();
        lqw.eq(BcxOrderDeviceNo::getId,request.getId());
        lqw.orderByDesc(BcxOrderDeviceNo::getId);
        Page<BcxOrderDeviceNo> page = PageHelper.startPage(pageParamRequest.getPage(), pageParamRequest.getLimit());
        List<BcxOrderDeviceNo> sources = dao.selectList(lqw);
        if (CollUtil.isEmpty(sources)) {
            return CommonPage.copyPageInfo(page, CollUtil.newArrayList());
        }
        List<BcxOrderDeviceNoResponse> result = transform(sources);
        return CommonPage.copyPageInfo(page, result);
    }
    private List<BcxOrderDeviceNoResponse> transform(List<BcxOrderDeviceNo> sources) {
        List<BcxOrderDeviceNoResponse> result = new ArrayList<>();
        for (BcxOrderDeviceNo source : sources) {
            BcxOrderDeviceNoResponse target = transform(source);
            result.add(target);
        }
        return result;
    }
    private BcxOrderDeviceNoResponse transform(BcxOrderDeviceNo source) {
        BcxOrderDeviceNoResponse target = new BcxOrderDeviceNoResponse();
        BeanUtils.copyProperties(source, target);
        // set another perperties
        return target;
    }
}
