package com.zbkj.service.wangshang.notify.service.impl;

import cn.hutool.core.date.DateUtil;
import com.github.pagehelper.util.StringUtil;
import com.google.common.collect.Lists;
import com.zbkj.common.constants.Constants;
import com.zbkj.common.dto.HuifuWalletAccountDetailDto;
import com.zbkj.common.dto.HuifuWalletAccountDto;
import com.zbkj.common.model.huifu.HuifuWalletTrade;
import com.zbkj.common.utils.DateUtils;
import com.zbkj.service.config.PaymentChannel;
import com.zbkj.service.dao.HuifuWalletAccountDao;
import com.zbkj.service.dao.HuifuWalletAccountDetailDao;
import com.zbkj.service.dao.HuifuWalletTradeDao;
import com.zbkj.service.service.TransactionLogService;
import com.zbkj.service.wangshang.api.domain.model.notify.BkcloudfundsMerchantAccountUnfreezeNotifyModel;
import com.zbkj.service.wangshang.api.internal.parser.xml.XmlConverter;
import com.zbkj.service.wangshang.api.domain.RequestHead;
import com.zbkj.service.wangshang.api.service.notify.BkcloudfundsMerchantAccountUnfreezeNotifyRequest;
import com.zbkj.service.wangshang.handle.CommomRequstHandle;
import com.zbkj.service.wangshang.notify.service.MybankNotifyService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * 商户余额解冻结果通知接口<ant.mybank.bkcloudfunds.merchant.account.unfreeze.notify>
 **/
@Service(value = "accountUnfreezeNotifyService")
public class BkcloudfundsMerchantAccountUnfreezeNotifyImpl implements MybankNotifyService {

    private static final Logger logger = LoggerFactory.getLogger(BkcloudfundsMerchantAccountUnfreezeNotifyImpl.class);
    @Autowired
    private CommomRequstHandle commomRequstHandle;
    @Resource
    private HuifuWalletTradeDao huifuWalletTradeDao;

    @Resource
    private HuifuWalletAccountDetailDao huifuWalletAccountDetailDao;

    @Resource
    private HuifuWalletAccountDao huifuWalletAccountDao;
    @Autowired
    TransactionLogService transactionLogService;


    @Override
    public String notifyHandle(String xmlContext, String function) throws Exception {
        //通知内容转换
        BkcloudfundsMerchantAccountUnfreezeNotifyRequest merchantAccountUnfreezeNotifyRequest =
                XmlConverter.getInstance().toResponse(xmlContext, BkcloudfundsMerchantAccountUnfreezeNotifyRequest.class);
        RequestHead head = merchantAccountUnfreezeNotifyRequest.getBkcloudfundsMerchantAccountUnfreezeNotify().getRequestHead();
        boolean flag = false;
        try {
            //通知内容保存
            flag = saveNotify(merchantAccountUnfreezeNotifyRequest.getBkcloudfundsMerchantAccountUnfreezeNotify().getBkcloudfundsMerchantAccountUnfreezeNotifyModel());
        }catch (Exception e){
            logger.error("========= > 商户余额解冻结果通知接口:ant.mybank.bkcloudfunds.merchant.account.unfreeze.notify:"+e.getMessage());
        }
        //响应结果根据执行结果统一处理
        String response = commomRequstHandle.getSignResult(flag, head);
        transactionLogService.save("商户余额解冻结果通知接口:ant.mybank.bkcloudfunds.merchant.account.unfreeze.notify", Constants.Y, xmlContext,response, PaymentChannel.WANGSHANG.toString());
        return response;
    }

    private boolean saveNotify(BkcloudfundsMerchantAccountUnfreezeNotifyModel model) {
        HuifuWalletTrade trade = huifuWalletTradeDao.getHuifuWalletTradeByHfSeqId(model.getOperateNo());
        //已经有结果了不继续往下走
        if(!Constants.TRADESTATUS_DJY.equals(trade.getTradeStatus())){
            return true;
        }
        if("SUCCESS".equals(model.getStatus())){
            trade.setUpdateTime(new Date());
            if(StringUtil.isNotEmpty(model.getFinishTime())){
                trade.setTransFinishTime(DateUtil.formatDateTime(DateUtil.parse(model.getFinishTime(),  "yyyy-MM-dd HH:mm:ss")));
            }
            trade.setTradeStatus(Constants.tradeStatus(Constants.ACCTSTAT_CG));//成功
        }else{
            trade.setErrorMsg(model.getErrorDesc());
            trade.setUpdateTime(new Date());
            trade.setTradeStatus(Constants.tradeStatus(Constants.ACCTSTAT_SB));//处理中
        }
        huifuWalletTradeDao.updateById(trade);

        return true;
    }

}
