package com.zbkj.service.wangshang.api.domain.model;

import com.alibaba.fastjson.annotation.JSONField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <b> 商户详情 </b>
 * @author ZXF
 * @create 2025/06/09 0009 13:32
 * @version
 * @注意事项 </b>
 */
@Data
public class MerchantUpdDetail implements Serializable {
    @ApiModelProperty(value = "商户简称")
    @JSONField(name = "Alias")
    private String alias;
    @ApiModelProperty(value = "联系人手机号")
    @JSONField(name = "ContactMobile")
    private String contactMobile;
    @ApiModelProperty(value = "联系人姓名")
    @JSONField(name = "ContactName")
    private String contactName;
    @ApiModelProperty(value = "负责人手机号，企业非必传")
    @JSONField(name = "PrincipalMobile")
    private String principalMobile;
    @ApiModelProperty(value = "身份证图片正面")
    @JSONField(name = "CertPhotoA")
    private String certPhotoA;
    @ApiModelProperty(value = "身份证图片反面")
    @JSONField(name = "CertPhotoB")
    private String certPhotoB;
    @ApiModelProperty(value = "营业执照图片")
    @JSONField(name = "LicensePhoto")
    private String licensePhoto;
    @ApiModelProperty(value = "营业执照有效期，如果营业执照证件照上传，则该字段必传")
    @JSONField(name = "BussAuthVld")
    private String bussAuthVld;
    @ApiModelProperty(value = "负责人证件有效期 如果负责人证件图片上传，则该字段必传")
    @JSONField(name = "PrincipalCertVld")
    private String principalCertVld;
    @ApiModelProperty(value = "身份证件有效期(自然人商户)")
    @JSONField(name = "PersonCertVld")
    private String personCertVld;
    @ApiModelProperty(value = "性别（自然人商户）")
    @JSONField(name = "PersonSex")
    private String personSex;
    @ApiModelProperty(value = "职业（自然人商户）")
    @JSONField(name = "PersonProfession")
    private String personProfession;
    @ApiModelProperty(value = "组织机构代码证图片")
    @JSONField(name = "PrgPhoto")
    private String prgPhoto;
    @ApiModelProperty(value = "开户许可证照片")
    @JSONField(name = "IndustryLicensePhoto")
    private String industryLicensePhoto;
    @ApiModelProperty(value = "门头照")
    @JSONField(name = "ShopPhoto")
    private String shopPhoto;
    @ApiModelProperty(value = "其他图片")
    @JSONField(name = "OtherPhoto")
    private String otherPhoto;
    @ApiModelProperty(value = "其他图片")
    @JSONField(name = "CheckStandPhoto")
    private String checkStandPhoto;
    @ApiModelProperty(value = "门店内景照片")
    @JSONField(name = "ShopEntrancePhoto")
    private String shopEntrancePhoto;
    @ApiModelProperty(value = "手持身份证照片")
    @JSONField(name = "CertPhotoC")
    private String certPhotoC;
    @ApiModelProperty(value = "租赁协议照片")
    @JSONField(name = "ContractPhoto")
    private String contractPhoto;
    @ApiModelProperty(value = "税务登记证号码")
    @JSONField(name = "TaxNum")
    private String taxNum;
    @ApiModelProperty(value = "控股人姓名")
    @JSONField(name = "ShareholderName")
    private String shareholderName;
    @ApiModelProperty(value = "控股人身份证件类型")
    @JSONField(name = "ShareholderCertType")
    private String shareholderCertType;
    @ApiModelProperty(value = "控股人证件号")
    @JSONField(name = "ShareholderCertNo")
    private String shareholderCertNo;
    @ApiModelProperty(value = "控股人身份证有效期")
    @JSONField(name = "ShareholderCertVld")
    private String shareholderCertVld;
    @ApiModelProperty(value = "省份")
    @JSONField(name = "Province")
    private String province;
    @ApiModelProperty(value = "城市")
    @JSONField(name = "City")
    private String city;
    @ApiModelProperty(value = "区（县）")
    @JSONField(name = "District")
    private String district;
    @ApiModelProperty(value = "详细地址")
    @JSONField(name = "Address")
    private String address;
    @ApiModelProperty(value = "商户客服电话")
    @JSONField(name = "ServicePhoneNo")
    private String servicePhoneNo;
    @ApiModelProperty(value = "邮箱")
    @JSONField(name = "Email")
    private String email;

}
