package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.bcx.BcxProductQuota;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.BcxProductQuotaRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.response.BcxProductQuotaResponse;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.service.dao.BcxProductQuotaDao;
import com.zbkj.service.service.BcxProductQuotaService;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;

/**
 * 商品限购表 服务实现类
 */
@Service
public class BcxProductQuotaServiceImpl extends ServiceImpl<BcxProductQuotaDao, BcxProductQuota> implements BcxProductQuotaService {

    @Resource
    private BcxProductQuotaDao dao;

    @Override
    public BcxProductQuotaResponse queryById(Integer id) {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        HashMap<String, Object> param = new HashMap<>();
        param.put("merId", systemAdmin.getMerId());
        param.put("id", id);
        List<BcxProductQuotaResponse> quotas = dao.quoryQuotaList(param);
        if (CollUtil.isEmpty(quotas)) {
            throw new CrmebException("没有找到属于该商户的商品限额");
        }
        return quotas.get(0);
    }

    @Override
    public BcxProductQuota queryByProductId(Integer productId) {
        LambdaQueryWrapper<BcxProductQuota> lqw = new LambdaQueryWrapper<>();
        lqw.eq(BcxProductQuota::getProductId,productId);
        lqw.eq(BcxProductQuota::getEnabled,Boolean.TRUE);
        lqw.last(" limit 1");
        return dao.selectOne(lqw);
    }

    @Override
    public PageInfo<BcxProductQuotaResponse> getPagedList(BcxProductQuotaRequest request, PageParamRequest pageParamRequest) {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        HashMap<String, Object> param = new HashMap<>();
        param.put("merId", systemAdmin.getMerId());
        param.put("name", request.getName());
        param.put("enabled", request.getEnabled());
        Page<BcxProductQuota> page = PageHelper.startPage(pageParamRequest.getPage(), pageParamRequest.getLimit());
        List<BcxProductQuotaResponse> quotas = dao.quoryQuotaList(param);
        if (CollUtil.isEmpty(quotas)) {
            return CommonPage.copyPageInfo(page, CollUtil.newArrayList());
        }
        return CommonPage.copyPageInfo(page, quotas);
    }

    @Override
    public Boolean create(BcxProductQuotaRequest bcxProductQuota) {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        HashMap<String, Object> param = new HashMap<>();
        param.put("merId", systemAdmin.getMerId());
        param.put("productId", bcxProductQuota.getProductId());
        List<BcxProductQuotaResponse> quotas = dao.quoryQuotaList(param);
        if (CollUtil.isNotEmpty(quotas)) {
            throw new CrmebException("已经有该商品的限购记录");
        }
        BcxProductQuota quota = new BcxProductQuota();
        BeanUtils.copyProperties(bcxProductQuota, quota);
        quota.setId(null);
        if (dao.insert(quota) > 0) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean update(BcxProductQuotaRequest bcxProductQuota) {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        HashMap<String, Object> param = new HashMap<>();
        param.put("merId", systemAdmin.getMerId());
        param.put("id", bcxProductQuota.getId());
        param.put("productId", bcxProductQuota.getProductId());
        List<BcxProductQuotaResponse> quotas = dao.quoryQuotaList(param);
        if (CollUtil.isEmpty(quotas)) {
            throw new CrmebException("找不到该商品的限购记录");
        }
        BcxProductQuota quota = new BcxProductQuota();
        BeanUtils.copyProperties(bcxProductQuota, quota);
        if (dao.updateById(quota) > 0) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean delete(Integer id) {
        BcxProductQuota quota = dao.selectById(id);
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        HashMap<String, Object> param = new HashMap<>();
        param.put("merId", systemAdmin.getMerId());
        param.put("id", quota.getId());
        param.put("productId", quota.getProductId());
        List<BcxProductQuotaResponse> quotas = dao.quoryQuotaList(param);
        if (CollUtil.isEmpty(quotas)) {
            throw new CrmebException("找不到该商品的限购记录");
        }
        if (dao.deleteById(id) > 0) {
            return true;
        }
        return false;
    }
}
