/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.model.CannedAccessControlList;
import com.qcloud.cos.model.CreateBucketRequest;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.vo.CloudVo;
import com.zbkj.service.service.CosService;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CosServiceImpl
implements CosService {
    private static final Logger logger = LoggerFactory.getLogger(CosServiceImpl.class);

    @Override
    public void uploadFile(CloudVo cloudVo, String webPth, String localFile, Integer id, COSClient cosClient) {
        logger.info("\u4e0a\u4f20\u6587\u4ef6" + id + "\u5f00\u59cb\uff1a" + localFile);
        try {
            File file = new File(localFile);
            if (!file.exists()) {
                logger.info("\u4e0a\u4f20\u6587\u4ef6" + id + localFile + "\u4e0d\u5b58\u5728\uff1a");
                return;
            }
            if (!cosClient.doesBucketExist(cloudVo.getBucketName())) {
                CreateBucketRequest createBucketRequest = new CreateBucketRequest(cloudVo.getBucketName());
                createBucketRequest.setCannedAcl(CannedAccessControlList.Private);
                try {
                    cosClient.createBucket(createBucketRequest);
                }
                catch (CosClientException serverException) {
                    serverException.printStackTrace();
                }
            }
            PutObjectRequest putObjectRequest = new PutObjectRequest(cloudVo.getBucketName(), webPth, file);
            PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
            logger.info("\u4e0a\u4f20\u6587\u4ef6" + id + " -- \u7ed3\u675f\uff1a" + putObjectResult.getETag());
        }
        catch (Exception e) {
            throw new CrmebException(e.getMessage());
        }
    }
}

