/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.internal.util.AlipaySignature;
import com.zbkj.common.constants.AlipayConfig;
import com.zbkj.common.constants.OrderConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.alipay.AliPayCallback;
import com.zbkj.common.model.order.Order;
import com.zbkj.common.model.order.RechargeOrder;
import com.zbkj.common.model.order.RefundOrder;
import com.zbkj.common.model.user.User;
import com.zbkj.common.model.wechat.WechatPayInfo;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.common.utils.WxPayUtil;
import com.zbkj.common.vo.AttachVo;
import com.zbkj.common.vo.MyRecord;
import com.zbkj.common.vo.WechatPayCallbackVo;
import com.zbkj.service.service.AliPayCallbackService;
import com.zbkj.service.service.AsyncService;
import com.zbkj.service.service.OrderService;
import com.zbkj.service.service.PayCallbackService;
import com.zbkj.service.service.RechargeOrderService;
import com.zbkj.service.service.RefundOrderService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.UserService;
import com.zbkj.service.service.WechatPayInfoService;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class PayCallbackServiceImpl
implements PayCallbackService {
    private static final Logger logger = LoggerFactory.getLogger(PayCallbackServiceImpl.class);
    @Autowired
    private OrderService orderService;
    @Autowired
    private UserService userService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private WechatPayInfoService wechatPayInfoService;
    @Autowired
    private RechargeOrderService rechargeOrderService;
    @Autowired
    @Lazy
    private AsyncService asyncService;
    @Autowired
    private RefundOrderService refundOrderService;
    @Autowired
    private AliPayCallbackService aliPayCallbackService;
    private static final List<String> list = new ArrayList<String>();

    @Override
    public String wechatPayCallback(String xmlInfo) {
        StringBuffer sb = new StringBuffer();
        sb.append("<xml>");
        if (StrUtil.isBlank((CharSequence)xmlInfo)) {
            sb.append("<return_code><![CDATA[FAIL]]></return_code>");
            sb.append("<return_msg><![CDATA[xmlInfo is blank]]></return_msg>");
            sb.append("</xml>");
            logger.error("wechat callback error : " + sb);
            return sb.toString();
        }
        try {
            HashMap map = WxPayUtil.processResponseXml((String)xmlInfo);
            String returnCode = (String)map.get("return_code");
            if (!returnCode.equals("SUCCESS")) {
                sb.append("<return_code><![CDATA[SUCCESS]]></return_code>");
                sb.append("<return_msg><![CDATA[OK]]></return_msg>");
                sb.append("</xml>");
                logger.error("wechat callback error : wx pay return code is fail returnMsg : " + map.get("return_msg"));
                return sb.toString();
            }
            String resultCode = (String)map.get("result_code");
            if (!resultCode.equals("SUCCESS")) {
                sb.append("<return_code><![CDATA[SUCCESS]]></return_code>");
                sb.append("<return_msg><![CDATA[OK]]></return_msg>");
                sb.append("</xml>");
                logger.error("wechat callback error : wx pay result code is fail");
                return sb.toString();
            }
            WechatPayCallbackVo callbackVo = (WechatPayCallbackVo)CrmebUtil.mapToObj((HashMap)map, WechatPayCallbackVo.class);
            AttachVo attachVo = (AttachVo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)callbackVo.getAttach()), AttachVo.class);
            User user = (User)this.userService.getById(attachVo.getUserId());
            if (ObjectUtil.isNull((Object)user)) {
                throw new CrmebException("\u7528\u6237\u4fe1\u606f\u9519\u8bef\uff01");
            }
            if (!"order".equals(attachVo.getType()) && !"recharge".equals(attachVo.getType())) {
                logger.error("wechat pay err : \u672a\u77e5\u7684\u652f\u4ed8\u7c7b\u578b==\u300b" + callbackVo.getOutTradeNo());
                throw new CrmebException("\u672a\u77e5\u7684\u652f\u4ed8\u7c7b\u578b\uff01");
            }
            if ("order".equals(attachVo.getType())) {
                Order order = this.orderService.getByOutTradeNo(callbackVo.getOutTradeNo());
                if (ObjectUtil.isNull((Object)order) || !order.getUid().equals(attachVo.getUserId())) {
                    logger.error("wechat pay error : \u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728==\u300b" + callbackVo.getOutTradeNo());
                    throw new CrmebException("wechat pay error : \u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728==\u300b" + callbackVo.getOutTradeNo());
                }
                if (order.getPaid().booleanValue()) {
                    logger.info("wechat pay info : \u8ba2\u5355\u5df2\u5904\u7406==\u300b" + callbackVo.getOutTradeNo());
                    sb.append("<return_code><![CDATA[SUCCESS]]></return_code>");
                    sb.append("<return_msg><![CDATA[OK]]></return_msg>");
                    sb.append("</xml>");
                    return sb.toString();
                }
                WechatPayInfo wechatPayInfo = this.wechatPayInfoService.getByNo(order.getOutTradeNo());
                if (ObjectUtil.isNull((Object)wechatPayInfo)) {
                    logger.error("wechat pay error : \u5fae\u4fe1\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728==\u300b" + callbackVo.getOutTradeNo());
                    throw new CrmebException("wechat pay error : \u5fae\u4fe1\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728==\u300b" + callbackVo.getOutTradeNo());
                }
                wechatPayInfo.setIsSubscribe(callbackVo.getIsSubscribe());
                wechatPayInfo.setBankType(callbackVo.getBankType());
                wechatPayInfo.setCashFee(callbackVo.getCashFee());
                wechatPayInfo.setCouponFee(callbackVo.getCouponFee());
                wechatPayInfo.setTransactionId(callbackVo.getTransactionId());
                wechatPayInfo.setTimeEnd(callbackVo.getTimeEnd());
                Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
                    order.setPaid(Boolean.valueOf(true));
                    order.setPayTime(CrmebDateUtil.nowDateTime());
                    order.setStatus(OrderConstants.ORDER_STATUS_WAIT_SHIPPING);
                    this.orderService.updateById(order);
                    this.wechatPayInfoService.updateById(wechatPayInfo);
                    return Boolean.TRUE;
                });
                if (!execute.booleanValue()) {
                    logger.error("wechat pay error : \u8ba2\u5355\u66f4\u65b0\u5931\u8d25==\u300b" + callbackVo.getOutTradeNo());
                    sb.append("<return_code><![CDATA[SUCCESS]]></return_code>");
                    sb.append("<return_msg><![CDATA[OK]]></return_msg>");
                    sb.append("</xml>");
                    return sb.toString();
                }
                this.asyncService.orderPaySuccessSplit(order.getOrderNo());
            }
            if ("recharge".equals(attachVo.getType())) {
                RechargeOrder rechargeOrder = this.rechargeOrderService.getByOutTradeNo(callbackVo.getOutTradeNo());
                if (ObjectUtil.isNull((Object)rechargeOrder)) {
                    logger.error("\u5145\u503c\u8ba2\u5355\u540e\u7f6e\u5904\u7406\uff0c\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u8ba2\u5355\uff0c\u652f\u4ed8\u670d\u52a1\u65b9\u8ba2\u5355\u53f7\uff1a{}", (Object)callbackVo.getOutTradeNo());
                    throw new CrmebException("\u6ca1\u6709\u627e\u5230\u5145\u503c\u8ba2\u5355\u4fe1\u606f");
                }
                if (rechargeOrder.getPaid().booleanValue()) {
                    sb.append("<return_code><![CDATA[SUCCESS]]></return_code>");
                    sb.append("<return_msg><![CDATA[OK]]></return_msg>");
                    sb.append("</xml>");
                    return sb.toString();
                }
                Boolean rechargePayAfter = this.rechargeOrderService.paySuccessAfter(rechargeOrder);
                if (!rechargePayAfter.booleanValue()) {
                    logger.error("wechat recharge pay after error : \u6570\u636e\u4fdd\u5b58\u5931\u8d25==\u300b" + callbackVo.getOutTradeNo());
                    throw new CrmebException("wechat recharge pay after error : \u6570\u636e\u4fdd\u5b58\u5931\u8d25==\u300b" + callbackVo.getOutTradeNo());
                }
            }
            sb.append("<return_code><![CDATA[SUCCESS]]></return_code>");
            sb.append("<return_msg><![CDATA[OK]]></return_msg>");
        }
        catch (Exception e2) {
            sb.append("<return_code><![CDATA[FAIL]]></return_code>");
            sb.append("<return_msg><![CDATA[").append(e2.getMessage()).append("]]></return_msg>");
            logger.error("wechat pay error : \u4e1a\u52a1\u5f02\u5e38==\u300b" + e2.getMessage());
        }
        sb.append("</xml>");
        logger.info("wechat callback response : " + sb);
        return sb.toString();
    }

    @Override
    public String aliPayCallback(HttpServletRequest request) {
        Map<String, String> params = this.convertRequestParamsToMap(request);
        String paramsJson = JSON.toJSONString(params);
        logger.info("\u652f\u4ed8\u5b9d\u56de\u8c03 = " + paramsJson);
        this.saveAliPayCallbackInfo(params);
        try {
            Order order;
            String outTradeNo = params.get("out_trade_no");
            String outRequestNo = params.get("out_request_no");
            String refundFee = params.get("refund_fee");
            if (StrUtil.isNotBlank((CharSequence)refundFee)) {
                logger.info("\u652f\u4ed8\u5b9d\u8fdb\u5165\u9000\u6b3e\u56de\u8c03");
                BigDecimal bigDecimal = new BigDecimal(refundFee);
                if (bigDecimal.compareTo(BigDecimal.ZERO) <= 0) {
                    logger.error("ali pay error : \u8ba2\u5355\u9000\u6b3e\u91d1\u989d\u5c0f\u4e8e\u7b49\u4e8e0==\u300b" + paramsJson);
                    return "fail";
                }
                RefundOrder refundOrder = this.refundOrderService.getByRefundOrderNo(outRequestNo);
                if (ObjectUtil.isNull((Object)refundOrder)) {
                    logger.error("ali pay error : \u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728==\u300b" + outRequestNo);
                    return "fail";
                }
                if (refundOrder.getRefundStatus().equals(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUND)) {
                    logger.warn("ali pay warn : \u8ba2\u5355\u9000\u6b3e\u5df2\u5904\u7406==\u300b" + paramsJson);
                    return "success";
                }
                refundOrder.setRefundStatus(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUND);
                boolean update = this.refundOrderService.updateById(refundOrder);
                if (update) {
                    this.redisUtil.lPush("alterOrderRefundByUser", (Object)refundOrder.getRefundOrderNo());
                } else {
                    logger.warn("\u652f\u4ed8\u5b9d\u9000\u6b3e\u8ba2\u5355\u66f4\u65b0\u5931\u8d25==>" + paramsJson);
                }
                return "success";
            }
            String passbackParams = params.get("passback_params");
            if (StrUtil.isNotBlank((CharSequence)passbackParams)) {
                String decode;
                try {
                    decode = URLDecoder.decode(passbackParams, "utf-8");
                }
                catch (UnsupportedEncodingException e2) {
                    e2.printStackTrace();
                    logger.error("ali pay error : \u8ba2\u5355\u652f\u4ed8\u7c7b\u578b\u89e3\u7801\u5931\u8d25==\u300b" + outTradeNo);
                    return "fail";
                }
                String[] split = decode.split("=");
                String orderType = split[1];
                if ("recharge".equals(orderType)) {
                    RechargeOrder rechargeOrder = this.rechargeOrderService.getByOutTradeNo(outTradeNo);
                    if (ObjectUtil.isNull((Object)rechargeOrder)) {
                        logger.error("ali pay error : \u5145\u503c\u8ba2\u5355\u540e\u7f6e\u5904\u7406\uff0c\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u8ba2\u5355\uff0c\u652f\u4ed8\u670d\u52a1\u65b9\u8ba2\u5355\u53f7\uff1a{}", (Object)outTradeNo);
                        return "fail";
                    }
                    if (rechargeOrder.getPaid().booleanValue()) {
                        return "success";
                    }
                    Boolean rechargePayAfter = this.rechargeOrderService.paySuccessAfter(rechargeOrder);
                    if (!rechargePayAfter.booleanValue()) {
                        logger.error("ali pay recharge pay after error : \u6570\u636e\u4fdd\u5b58\u5931\u8d25==\u300b" + outTradeNo);
                        return "fail";
                    }
                    return "success";
                }
            }
            if (ObjectUtil.isNull((Object)(order = this.orderService.getByOrderNo(outTradeNo)))) {
                logger.error("ali pay error : \u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728==\u300b" + outTradeNo);
                return "fail";
            }
            if (order.getPaid().booleanValue()) {
                logger.error("ali pay error : \u8ba2\u5355\u5df2\u5904\u7406==\u300b" + outTradeNo);
                return "success";
            }
            User user = (User)this.userService.getById(order.getUid());
            if (ObjectUtil.isNull((Object)user)) {
                logger.error("\u652f\u4ed8\u5b9d\u56de\u8c03\u7528\u6237\u4fe1\u606f\u9519\u8bef\uff0cparamsJson = " + paramsJson);
                return "fail";
            }
            String tradeNo = params.get("trade_no");
            String tradeStatus = params.get("trade_status");
            String aliPayPublicKey2 = this.systemConfigService.getValueByKey(AlipayConfig.ALIPAY_PUBLIC_KEY_2);
            boolean signVerified = AlipaySignature.rsaCheckV1(params, (String)aliPayPublicKey2, (String)AlipayConfig.CHARSET, (String)"RSA2");
            if (signVerified) {
                logger.info("\u652f\u4ed8\u5b9d\u56de\u8c03\u7b7e\u540d\u8ba4\u8bc1\u6210\u529f");
                if (tradeStatus.equals("TRADE_FINISHED") || tradeStatus.equals("TRADE_SUCCESS")) {
                    Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
                        order.setPaid(Boolean.valueOf(true));
                        order.setPayTime(CrmebDateUtil.nowDateTime());
                        order.setStatus(OrderConstants.ORDER_STATUS_WAIT_SHIPPING);
                        this.orderService.updateById(order);
                        return Boolean.TRUE;
                    });
                    if (!execute.booleanValue()) {
                        logger.error("ali pay error : \u8ba2\u5355\u66f4\u65b0\u5931\u8d25==\u300b" + outTradeNo);
                        return "fail";
                    }
                    this.asyncService.orderPaySuccessSplit(order.getOrderNo());
                }
                return "success";
            }
            logger.info("\u652f\u4ed8\u5b9d\u56de\u8c03\u7b7e\u540d\u8ba4\u8bc1\u5931\u8d25\uff0csignVerified=false, paramsJson:{}", (Object)paramsJson);
            return "fail";
        }
        catch (AlipayApiException e3) {
            logger.error("\u652f\u4ed8\u5b9d\u56de\u8c03\u7b7e\u540d\u8ba4\u8bc1\u5931\u8d25,paramsJson:{},errorMsg:{}", (Object)paramsJson, (Object)e3.getMessage());
            return "fail";
        }
    }

    private void saveAliPayCallbackInfo(Map<String, String> params) {
        AliPayCallback aliPayCallback = new AliPayCallback();
        aliPayCallback.setNotifyType(params.get("notify_type"));
        aliPayCallback.setNotifyId(params.get("notify_id"));
        aliPayCallback.setAppId(params.get("app_id"));
        aliPayCallback.setCharset(params.get("charset"));
        aliPayCallback.setVersion(params.get("version"));
        aliPayCallback.setSignType(params.get("sign_type"));
        aliPayCallback.setSign(params.get("sign"));
        aliPayCallback.setTradeNo(params.get("trade_no"));
        aliPayCallback.setOutTradeNo(params.get("out_trade_no"));
        aliPayCallback.setTradeStatus(params.get("trade_status"));
        aliPayCallback.setTotalAmount(new BigDecimal(params.get("total_amount")));
        aliPayCallback.setReceiptAmount(new BigDecimal(params.get("receipt_amount")));
        aliPayCallback.setRefundFee(ObjectUtil.isNotNull((Object)params.get("refund_fee")) ? new BigDecimal(params.get("refund_fee")) : null);
        aliPayCallback.setSubject(params.get("subject"));
        aliPayCallback.setBody(Optional.ofNullable(params.get("body")).orElse(""));
        aliPayCallback.setPassbackParams(params.get("passback_params"));
        aliPayCallback.setNotifyTime((Date)DateUtil.parse((String)params.get("notify_time")));
        aliPayCallback.setAddTime((Date)DateUtil.date());
        this.aliPayCallbackService.save(aliPayCallback);
    }

    private Map<String, String> convertRequestParamsToMap(HttpServletRequest request) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        Map requestParams = request.getParameterMap();
        for (String name : requestParams.keySet()) {
            String[] values = (String[])requestParams.get(name);
            String valueStr = "";
            for (int i = 0; i < values.length; ++i) {
                valueStr = i == values.length - 1 ? valueStr + values[i] : valueStr + values[i] + ",";
            }
            retMap.put(name, valueStr);
        }
        return retMap;
    }

    @Override
    public String weChatRefund(String xmlInfo) {
        MyRecord notifyRecord = new MyRecord();
        MyRecord refundRecord = this.refundNotify(xmlInfo, notifyRecord);
        if (refundRecord.getStr("status").equals("fail")) {
            logger.error("\u5fae\u4fe1\u9000\u6b3e\u56de\u8c03\u5931\u8d25==>" + refundRecord.getColumns() + ", rawData==>" + xmlInfo + ", data==>" + notifyRecord);
            return refundRecord.getStr("returnXml");
        }
        if (!refundRecord.getBoolean("isRefund").booleanValue()) {
            logger.error("\u5fae\u4fe1\u9000\u6b3e\u56de\u8c03\u5931\u8d25==>" + refundRecord.getColumns() + ", rawData==>" + xmlInfo + ", data==>" + notifyRecord);
            return refundRecord.getStr("returnXml");
        }
        String outRefundNo = notifyRecord.getStr("out_refund_no");
        RefundOrder refundOrder = this.refundOrderService.getByRefundOrderNo(outRefundNo);
        if (ObjectUtil.isNull((Object)refundOrder)) {
            logger.error("\u5fae\u4fe1\u9000\u6b3e\u8ba2\u5355\u67e5\u8be2\u5931\u8d25==>" + refundRecord.getColumns() + ", rawData==>" + xmlInfo + ", data==>" + notifyRecord);
            return refundRecord.getStr("returnXml");
        }
        if (refundOrder.getRefundStatus().equals(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUND)) {
            logger.warn("\u5fae\u4fe1\u9000\u6b3e\u8ba2\u5355\u5df2\u786e\u8ba4\u6210\u529f==>" + refundRecord.getColumns() + ", rawData==>" + xmlInfo + ", data==>" + notifyRecord);
            return refundRecord.getStr("returnXml");
        }
        refundOrder.setRefundStatus(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUND);
        boolean update = this.refundOrderService.updateById(refundOrder);
        if (update) {
            this.redisUtil.lPush("alterOrderRefundByUser", (Object)refundOrder.getRefundOrderNo());
        } else {
            logger.warn("\u5fae\u4fe1\u9000\u6b3e\u8ba2\u5355\u66f4\u65b0\u5931\u8d25==>" + refundRecord.getColumns() + ", rawData==>" + xmlInfo + ", data==>" + notifyRecord);
        }
        return refundRecord.getStr("returnXml");
    }

    private MyRecord refundNotify(String xmlInfo, MyRecord notifyRecord) {
        Map respMap;
        MyRecord refundRecord = new MyRecord();
        refundRecord.set("status", (Object)"fail");
        StringBuilder sb = new StringBuilder();
        sb.append("<xml>");
        if (StrUtil.isBlank((CharSequence)xmlInfo)) {
            sb.append("<return_code><![CDATA[FAIL]]></return_code>");
            sb.append("<return_msg><![CDATA[xmlInfo is blank]]></return_msg>");
            sb.append("</xml>");
            logger.error("wechat refund callback error : " + sb);
            return refundRecord.set("returnXml", (Object)sb.toString()).set("errMsg", (Object)"xmlInfo is blank");
        }
        try {
            respMap = WxPayUtil.xmlToMap((String)xmlInfo);
        }
        catch (Exception e) {
            sb.append("<return_code><![CDATA[FAIL]]></return_code>");
            sb.append("<return_msg><![CDATA[").append(e.getMessage()).append("]]></return_msg>");
            sb.append("</xml>");
            logger.error("wechat refund callback error : " + e.getMessage());
            return refundRecord.set("returnXml", (Object)sb.toString()).set("errMsg", (Object)e.getMessage());
        }
        notifyRecord.setColums(this._strMap2ObjMap(respMap));
        String return_code = (String)respMap.get("return_code");
        if (return_code.equals("SUCCESS")) {
            String appid = (String)respMap.get("appid");
            String signKey = this.getSignKey(appid);
            String reqInfo = (String)respMap.get("req_info");
            System.out.println("encodeReqInfo==>" + reqInfo);
            try {
                String decodeInfo = PayCallbackServiceImpl.decryptToStr(reqInfo, signKey);
                Map infoMap = WxPayUtil.xmlToMap((String)decodeInfo);
                notifyRecord.setColums(this._strMap2ObjMap(infoMap));
                String refund_status = (String)infoMap.get("refund_status");
                refundRecord.set("isRefund", (Object)refund_status.equals("SUCCESS"));
            }
            catch (Exception e) {
                refundRecord.set("isRefund", (Object)false);
                logger.error("\u5fae\u4fe1\u9000\u6b3e\u56de\u8c03\u5f02\u5e38\uff0ce==\u300b" + e.getMessage());
            }
        } else {
            notifyRecord.set("return_msg", respMap.get("return_msg"));
            refundRecord.set("isRefund", (Object)false);
        }
        sb.append("<return_code><![CDATA[SUCCESS]]></return_code>");
        sb.append("<return_msg><![CDATA[OK]]></return_msg>");
        sb.append("</xml>");
        return refundRecord.set("returnXml", (Object)sb.toString()).set("status", (Object)"ok");
    }

    private String getSignKey(String appid) {
        String publicAppid = this.systemConfigService.getValueByKey("wechat_appid");
        String miniAppid = this.systemConfigService.getValueByKey("routine_appid");
        String appAppid = this.systemConfigService.getValueByKey("wechat_app_appid");
        String signKey = "";
        if (StrUtil.isBlank((CharSequence)publicAppid) && StrUtil.isBlank((CharSequence)miniAppid) && StrUtil.isBlank((CharSequence)appAppid)) {
            throw new CrmebException("pay_weixin_appid\u6216pay_routine_appid\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
        }
        if (StrUtil.isNotBlank((CharSequence)publicAppid) && appid.equals(publicAppid)) {
            signKey = this.systemConfigService.getValueByKeyException("pay_weixin_key");
        }
        if (StrUtil.isNotBlank((CharSequence)miniAppid) && appid.equals(miniAppid)) {
            signKey = this.systemConfigService.getValueByKeyException("pay_routine_key");
        }
        if (StrUtil.isNotBlank((CharSequence)appAppid) && appid.equals(appAppid)) {
            signKey = this.systemConfigService.getValueByKeyException("pay_weixin_app_key");
        }
        return signKey;
    }

    public static String decryptToStr(String reqInfo, String signKey) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        byte[] decodeReqInfo = PayCallbackServiceImpl.base64DecodeJustForWxPay(reqInfo).getBytes(StandardCharsets.ISO_8859_1);
        SecretKeySpec key = new SecretKeySpec(SecureUtil.md5((String)signKey).toLowerCase().getBytes(), "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS7Padding");
        cipher.init(2, key);
        return new String(cipher.doFinal(decodeReqInfo), StandardCharsets.UTF_8);
    }

    private Map<String, Object> _strMap2ObjMap(Map<String, String> params) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (list.contains(entry.getKey())) {
                try {
                    map.put(entry.getKey(), Integer.parseInt(entry.getValue()));
                }
                catch (NumberFormatException e) {
                    map.put(entry.getKey(), 0);
                    logger.error("\u5b57\u6bb5\u683c\u5f0f\u9519\u8bef\uff0ckey==\u300b" + entry.getKey() + ", value==\u300b" + entry.getValue());
                }
                continue;
            }
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public static String base64DecodeJustForWxPay(String source) {
        String result = "";
        Base64.Decoder decoder = Base64.getDecoder();
        result = new String(decoder.decode(source), StandardCharsets.ISO_8859_1);
        return result;
    }

    static {
        list.add("total_fee");
        list.add("cash_fee");
        list.add("coupon_fee");
        list.add("coupon_count");
        list.add("refund_fee");
        list.add("settlement_refund_fee");
        list.add("settlement_total_fee");
        list.add("cash_refund_fee");
        list.add("coupon_refund_fee");
        list.add("coupon_refund_count");
    }
}

