/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.wangshang.notify.service.impl;

import com.zbkj.common.dto.HuifuWalletAccountDto;
import com.zbkj.common.model.huifu.HuifuWallet;
import com.zbkj.common.model.huifu.HuifuWalletAccount;
import com.zbkj.common.model.huifu.HuifuWalletProcess;
import com.zbkj.service.config.PaymentChannel;
import com.zbkj.service.dao.HuifuWalletAccountDao;
import com.zbkj.service.dao.HuifuWalletDao;
import com.zbkj.service.dao.HuifuWalletProcessDao;
import com.zbkj.service.huifu.constants.OpenProcess;
import com.zbkj.service.service.TransactionLogService;
import com.zbkj.service.wangshang.api.domain.RequestHead;
import com.zbkj.service.wangshang.api.domain.model.notify.MerchantprodMerchNotifyModel;
import com.zbkj.service.wangshang.api.internal.parser.xml.XmlConverter;
import com.zbkj.service.wangshang.api.service.notify.MerchantprodMerchNotifyRequest;
import com.zbkj.service.wangshang.handle.CommomRequstHandle;
import com.zbkj.service.wangshang.notify.service.MybankNotifyService;
import java.io.Serializable;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="bkMerchantprodMerchNotifyService")
public class BkMerchantprodMerchNotifyServiceImpl
implements MybankNotifyService {
    private static final Logger logger = LoggerFactory.getLogger(BkMerchantprodMerchNotifyServiceImpl.class);
    @Autowired
    private CommomRequstHandle commomRequstHandle;
    @Resource
    private HuifuWalletAccountDao huifuWalletAccountDao;
    @Resource
    private HuifuWalletProcessDao huifuWalletProcessDao;
    @Resource
    private HuifuWalletDao huifuWalletDao;
    @Autowired
    TransactionLogService transactionLogService;

    @Override
    public String notifyHandle(String context, String function) throws Exception {
        logger.info("========= > \u5546\u6237\u5165\u9a7b\u7ed3\u679c\u901a\u77e5\u63a5\u53e3\u901a\u77e5\u5b9e\u73b0\uff08\u5f02\u6b65\u901a\u77e5\uff09:ant.mybank.merchantprod.merch.notify");
        logger.info("========= > \u8bf7\u6c42\u62a5\u6587\uff1a" + context);
        MerchantprodMerchNotifyRequest merchantprodMerchNotifyRequest = XmlConverter.getInstance().toResponse(context, MerchantprodMerchNotifyRequest.class);
        RequestHead head = merchantprodMerchNotifyRequest.getMerchantprodMerchNotify().getRequestHead();
        boolean flag = false;
        try {
            flag = this.saveNotify(merchantprodMerchNotifyRequest.getMerchantprodMerchNotify().getMerchantprodMerchNotifyModel());
        }
        catch (Exception e) {
            logger.error("========= > \u5546\u6237\u5165\u9a7b\u7ed3\u679c\u901a\u77e5\u63a5\u53e3\u901a\u77e5\u5b9e\u73b0\uff08\u5f02\u6b65\u901a\u77e5\uff09:ant.mybank.merchantprod.merch.notify:" + e.getMessage());
        }
        String response = this.commomRequstHandle.getSignResult(flag, head);
        this.transactionLogService.save("\u5546\u6237\u5165\u9a7b\u7ed3\u679c\u901a\u77e5\u63a5\u53e3\u901a\u77e5\u5b9e\u73b0\uff08\u5f02\u6b65\u901a\u77e5\uff09:ant.mybank.merchantprod.merch.notify", "1", context, response, PaymentChannel.WANGSHANG.toString());
        return response;
    }

    private boolean saveNotify(MerchantprodMerchNotifyModel model) {
        HuifuWalletAccountDto dto = this.huifuWalletAccountDao.getHuifuWalletAccountByOutMerchantId(model.getOutMerchantId());
        if (dto == null) {
            return false;
        }
        Date now = new Date();
        HuifuWalletAccount hwa = (HuifuWalletAccount)this.huifuWalletAccountDao.selectById(dto.getId());
        HuifuWallet huifuWallet = this.huifuWalletDao.getHuifuWalletByUniId(hwa.getUniId(), PaymentChannel.WANGSHANG.toString());
        HuifuWalletProcess hp = this.huifuWalletProcessDao.getLastStepProcess(dto.getUniId(), PaymentChannel.WANGSHANG.toString());
        String registerStatus = model.getRegisterStatus();
        if ("1".equals(huifuWallet.getIsCompleteOpen())) {
            return true;
        }
        if ("1".equals(registerStatus)) {
            hwa.setUpdateTime(now);
            hwa.setFailReason("");
            if (hp.getStep() == 2 && "PRE_REGISTER_ASYNC_NOTIFY".equals(model.getAsyncNotifyType())) {
                hwa.setWalletAccountNo(model.getMerchantId());
                this.huifuWalletAccountDao.updateById(hwa);
                hp.setUpdateTime(now);
                hp.setIsComplete("1");
                this.huifuWalletProcessDao.updateById(hp);
                HuifuWalletProcess buildProcess = new HuifuWalletProcess();
                buildProcess.setUniId(hwa.getUniId());
                buildProcess.setCreateTime(now);
                buildProcess.setStep(Integer.valueOf(OpenProcess.SHJHZ.getSort()));
                buildProcess.setIsComplete("0");
                buildProcess.setDescription(OpenProcess.SHJHZ.getDesc());
                buildProcess.setPayChannel(PaymentChannel.WANGSHANG.toString());
                this.huifuWalletProcessDao.insert(buildProcess);
            } else if (hp.getStep() == 3 && "PRE_REGISTER_ACTIVATE_ASYNC_NOTIFY".equals(model.getAsyncNotifyType())) {
                hwa.setAcctStat("N");
                this.huifuWalletAccountDao.updateById(hwa);
                hp.setUpdateTime(now);
                hp.setIsComplete("1");
                this.huifuWalletProcessDao.updateById(hp);
                huifuWallet.setUniId(hwa.getUniId());
                huifuWallet.setUpdateTime(now);
                huifuWallet.setIsCompleteOpen("1");
                huifuWallet.setOpenTime(now);
                huifuWallet.setPayChannel(PaymentChannel.WANGSHANG.toString());
                this.huifuWalletDao.updateHuifuWallet(huifuWallet);
            }
        } else if ("2".equals(registerStatus)) {
            hwa.setFailReason(model.getFailReason());
            this.huifuWalletAccountDao.updateById(hwa);
            if (hp.getStep() == 2) {
                this.huifuWalletProcessDao.deleteById((Serializable)hp);
                HuifuWalletProcess huifuWalletProcess = this.huifuWalletProcessDao.getLastStepProcess(hwa.getUniId(), PaymentChannel.WANGSHANG.toString());
                huifuWalletProcess.setUpdateTime(now);
                huifuWalletProcess.setIsComplete("0");
                this.huifuWalletProcessDao.updateById(huifuWalletProcess);
            }
        }
        return true;
    }
}

