package com.zbkj.front.interceptor;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.zbkj.common.model.user.User;
import com.zbkj.common.result.CommonResult;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.token.FrontTokenComponent;
import com.zbkj.common.token.TokenUtils;
import com.zbkj.service.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 移动端管理端 token验证拦截器 使用前注意需要一个@Bean手动注解，否则注入无效
 * +----------------------------------------------------------------------
 * | CRMEB [ CRMEB赋能开发者，助力企业发展 ]
 * +----------------------------------------------------------------------
 * | Copyright (c) 2016~2023 https://www.crmeb.com All rights reserved.
 * +----------------------------------------------------------------------
 * | Licensed CRMEB并不是自由软件，未经许可不能去掉CRMEB相关版权
 * +----------------------------------------------------------------------
 * | Author: CRMEB Team <admin@crmeb.com>
 * +----------------------------------------------------------------------
 */
public class FrontTokenInterceptor implements HandlerInterceptor {
    @Autowired
    private FrontTokenComponent frontTokenComponent;

    @Autowired
    private UserService userService;

    //程序处理之前需要处理的业务
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Content-type", "text/html;charset=UTF-8");
        String bcxToken = TokenUtils.getBcxToken(request);
        if(StrUtil.isNotBlank(bcxToken)){
            Boolean exists = frontTokenComponent.checkBcxToken(bcxToken);
            if(exists){
                return true;
            }
            String account = TokenUtils.getAccountFromBcxToken(bcxToken);
            if (ObjectUtil.isEmpty(account)) {
                response.getWriter().write(JSONObject.toJSONString(CommonResult.failed(CommonResultCode.PERMISSION_EXPIRATION)));
                return false;
            }
            User user = userService.getByBcxAccount(account);
            if (ObjectUtil.isNull(user)) {
                response.getWriter().write(JSONObject.toJSONString(CommonResult.failed(CommonResultCode.USER_NOT_FOUND)));
                return false;
            }
            if (!user.getStatus()) {
                response.getWriter().write(JSONObject.toJSONString(CommonResult.failed(CommonResultCode.USER_DISABLED)));
                return false;
            }
            frontTokenComponent.createBcxToken(bcxToken,user);
            return true;
        }

        String token = frontTokenComponent.getToken(request);
        if (StrUtil.isBlank(token)) {
            response.getWriter().write(JSONObject.toJSONString(CommonResult.failed(CommonResultCode.UNAUTHORIZED)));
            return false;
        }

        Boolean result = frontTokenComponent.check(token);
        if (!result) {
            response.getWriter().write(JSONObject.toJSONString(CommonResult.failed(CommonResultCode.PERMISSION_EXPIRATION)));
            return false;
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {

    }

}
