package com.zbkj.common.response;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 商户端退款订单分页列表响应对象
 * +----------------------------------------------------------------------
 * | CRMEB [ CRMEB赋能开发者，助力企业发展 ]
 * +----------------------------------------------------------------------
 * | Copyright (c) 2016~2023 https://www.crmeb.com All rights reserved.
 * +----------------------------------------------------------------------
 * | Licensed CRMEB并不是自由软件，未经许可不能去掉CRMEB相关版权
 * +----------------------------------------------------------------------
 * | Author: CRMEB Team <admin@crmeb.com>
 * +----------------------------------------------------------------------
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "MerchantRefundOrderPageResponse对象", description = "商户端退款订单分页列表响应对象")
public class PlatformRefundOrderPageResponse extends CommonRefundOrderPageResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "商户ID")
    @ExcelIgnore
    private Integer merId;

    @ApiModelProperty(value = "商户名称")
    @ColumnWidth(50)
    @ExcelProperty(value = "商户名称", index = 5)
    private String merName;

    @ApiModelProperty(value = "服务人员")
    @ColumnWidth(50)
    @ExcelProperty(value = "服务人员", index = 11)
    private String memberName;

    @ApiModelProperty(value = "平台备注")
    @ColumnWidth(50)
    @ExcelProperty("平台备注")
    private String platformRemark;
}
