package com.zbkj.common.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 商品限购响应对象
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BcxProductQuotaResponse对象", description = "商品限购响应对象")
public class BcxProductQuotaResponse implements Serializable {
    private static final long serialVersionUID=123424234213L;

    @ApiModelProperty(value = "限购id")
    private Integer id;

    @ApiModelProperty(value = "限购商品id")
    private Integer productId;

    @ApiModelProperty(value = "启用限购 1-启用 0其他-不启用")
    private Boolean enabled;

    @ApiModelProperty(value = "单次限购数量")
    private Integer oneQuota;

    @ApiModelProperty(value = "用户总限购数量")
    private Integer allQuota;

    @ApiModelProperty(value = "商品图片")
    private String image;

    @ApiModelProperty(value = "商品名称")
    private String name;

    @ApiModelProperty(value = "商品价格")
    private BigDecimal price;

    @ApiModelProperty(value = "库存")
    private Integer stock;
}
