package com.zbkj.common.response;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * description: 部门表 response对象
 * author : linchunpeng
 * date : 2023/8/3
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BcxDepartmentResponse对象", description = "部门表 response对象")
public class BcxDepartmentResponse implements Serializable {

    @ApiModelProperty(value = "部门id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "部门code")
    private String deptCode;

    @ApiModelProperty(value = "上级部门code")
    private String parentCode;
    
    @ApiModelProperty(value = "部门名称")
    private String deptName;

    @ApiModelProperty(value = "子部门列表")
    private List<BcxDepartmentResponse> childrenList;

    @ApiModelProperty(value = "部门成员列表")
    private List<BcxDepartmentMemberResponse> memberList;

    public void addChildren(BcxDepartmentResponse children) {
        if (childrenList == null) {
            childrenList = new ArrayList<>();
        }
        childrenList.add(children);
    }

    public void addMember(BcxDepartmentMemberResponse member) {
        if (memberList == null) {
            memberList = new ArrayList<>();
        }
        memberList.add(member);
    }
}