package com.zbkj.common.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

/**
 * description：渠道/部门/部门成员-佣金配置保存request对象
 * author：linchunpeng
 * date：2023/8/4
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BcxBrokerageConfigDetailRequest对象", description = "渠道/部门/部门成员-佣金配置保存request对象")
public class BcxBrokerageConfigDetailRequest {

    @ApiModelProperty(value = "渠道/部门/部门成员 id")
    @NotNull(message = "渠道/部门/部门成员 id 不能为空")
    private Long belongId;

    @ApiModelProperty(value = "渠道/部门/部门成员 名称")
    @NotBlank(message = "渠道/部门/部门成员 名称 不能为空")
    private String belongName;

    @ApiModelProperty(value = "渠道类型：1业务渠道，2区域渠道")
    private Integer channelType;

    @ApiModelProperty(value = "佣金类型：1比例，2固定，3自留")
    @NotNull(message = "佣金类型 不能为空")
    private Integer type;

    @ApiModelProperty(value = "佣金")
    @NotNull(message = "佣金 不能为空")
    @DecimalMin(value = "0", message = "佣金 不能小于0")
    private BigDecimal ratio;

    @ApiModelProperty(value = "服务佣金")
    @DecimalMin(value = "0", message = "服务佣金 不能小于0")
    private BigDecimal serviceRatio;

    @ApiModelProperty(value = "计算系数")
    @Range(min = 0, max = 100, message = "计算系数在0-100中选择")
    private BigDecimal calculateRatio;

    @ApiModelProperty(value = "关联区域代码列表")
    @NotEmpty(message = "关联区域代码列表 不能为空")
    private List<String> regionCodeList;

}
