package com.zbkj.common.model.huifu;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * <b> 企业钱包业务入驻 </b>
 * @author ZXF
 * @create 2023/07/26 0026 16:48
 * @version
 * @注意事项 </b>
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("eb_huifu_wallet_busi")
@ApiModel(value="HuifuWalletBusi对象", description="企业钱包业务入驻")
public class HuifuWalletBusi implements Serializable {

    @ApiModelProperty(value = "id")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;
    @ApiModelProperty(value = "账户基础信息id")
    private Integer accountId;
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
    @ApiModelProperty(value = "流水号")
    private String reqSeqId;
    @ApiModelProperty(value = "银行卡绑定手机号")
    private String mp;
    @ApiModelProperty(value = "卡类型：对公，1：对私，2：对私非法人")
    private String cardType;
    @ApiModelProperty(value = "业务类型：D1：下一自然日到银行账户，D0：当日到银行账户；多个逗号隔开")
    private String cashType;
    @ApiModelProperty(value = "卡户名")
    private String cardName;
    @ApiModelProperty(value = "卡号")
    private String cardNo;
    @ApiModelProperty(value = "银行所在省")
    private String provId;
    @ApiModelProperty(value = "银行所在市")
    private String areaId;
    @ApiModelProperty(value = "银行号")
    private String bankCode;
    @ApiModelProperty(value = "支行联行号")
    private String branchCode;
    @ApiModelProperty(value = "支行名称")
    private String branchName;
    @ApiModelProperty(value = "取现卡序列号")
    private String tokenNo;
    @ApiModelProperty(value = "支付通道")
    private String payChannel;

}