package com.zbkj.common.model.bcx;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 订单线下支付
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("bcx_pay_offline")
@ApiModel(value = "BcxPayOffline对象", description = "订单线下支付")
public class BcxPayOffline implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "线下支付id")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "订单号")
    private String orderNo;

    @ApiModelProperty(value = "0-待支付 1-待确认 2-已确认 3-已到款")
    private Integer status;

    @ApiModelProperty(value = "收款户名")
    private String bankUserName;

    @ApiModelProperty(value = "收款银行")
    private String bankName;

    @ApiModelProperty(value = "银行卡号")
    private String bankCard;

    @ApiModelProperty(value = "用户支付说明")
    private String userMsg;

    @ApiModelProperty(value = "商户备注")
    private String merMsg;
}
