package com.zbkj.common.dto;

import com.zbkj.common.model.huifu.HuifuWalletAccount;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <b> 汇付回调参数接收 </b>
 * @author ZXF
 * @create 2023/07/31 0031 11:21
 * @version
 * @注意事项 </b>
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="HuifuRequestDataDto对象", description="汇付回调参数接收")
public class HuifuRequestDataDto implements Serializable {

    @ApiModelProperty(value = "业务返回码")
    private String resp_code;

    @ApiModelProperty(value = "业务返回描述")
    private String resp_desc;

    @ApiModelProperty(value = "加签结果")
    private String sign;
    @ApiModelProperty(value = "数据")
    private String data;

}
