package com.zbkj.common.response.excel;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.ContentStyle;
import com.alibaba.excel.enums.poi.HorizontalAlignmentEnum;
import com.alibaba.excel.enums.poi.VerticalAlignmentEnum;
import com.zbkj.common.enums.BcxBillSettleStatusEnum;
import com.zbkj.common.utils.DateConverter;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * description: 业绩账单-基础导出excel dto对象
 * author : linchunpeng
 * date : 2023/8/3
 */
@Data
public class BcxSettleBillBaseExcelDto implements Serializable {


    @ExcelProperty(value = "账期", order = 11)
    @ColumnWidth(15)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String billPeriod;

    @ExcelProperty(value = "订单数（笔）", order = 12)
    @ColumnWidth(20)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private Integer orderCount;

    @ExcelProperty(value = "订单总金额（元）", order = 13)
    @ColumnWidth(25)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private BigDecimal orderTotalPrice;

    @ExcelProperty(value = "佣金总额（元）", order = 14)
    @ColumnWidth(20)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private BigDecimal brokerageTotalPrice;

    @ExcelIgnore
    private Integer settleStatus;
    @ExcelProperty(value = "结算状态", order = 15)
    @ColumnWidth(15)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String settleStatusName;

    @ExcelProperty(value = "账单生成时间", converter = DateConverter.class, order = 16)
    @ColumnWidth(20)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private Date createTime;

    public String getSettleStatusName() {
        if (settleStatus != null) {
            return BcxBillSettleStatusEnum.getInstance(settleStatus).getName();
        }
        return null;
    }
}