package com.zbkj.common.request.bcx;

import com.zbkj.common.model.bcx.BcxPayOfflineFile;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BcxMerchantPayOfflineRequest对象", description = "商户确认线下支付请求对象")
public class BcxMerchantPayOfflineRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "订单号")
    @NotEmpty(message = "订单号不能为空")
    private String orderNo;

    @ApiModelProperty(value = "备注")
    private String merMsg;

    @ApiModelProperty(value = "凭证url列表")
    private List<BcxPayOfflineFileAddRequest> fileList;
}
