package com.zbkj.common.enums;

/**
 * description：支付方式：1线下结算，2企业钱包结算，3第三方支付结算
 * author：linchunpeng
 * date：2023/8/4
 */
public enum BcxPerformanceReportPayWayEnum {

    OFFLINE("线下结算", 1),
    PURSE("企业钱包结算", 2),
    THIRD_PARTY("第三方支付结算", 3);

    private final String name;
    private final Integer value;

    BcxPerformanceReportPayWayEnum(String name, Integer value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public Integer getValue() {
        return value;
    }

    public static BcxPerformanceReportPayWayEnum getInstance(int value) {
        switch (value) {
            case 1:
                return OFFLINE;
            case 2:
                return PURSE;
            case 3:
                return THIRD_PARTY;
        }
        return null;
    }
}
