package com.zbkj.common.dto;

import com.zbkj.common.model.huifu.HuifuWalletAccountDetail;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;

/**
 * <b> 钱包账户明细dto </b>
 * @author ZXF
 * @create 2023/07/31 0031 11:21
 * @version
 * @注意事项 </b>
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="HuifuWalletAccountDetailDto对象", description="钱包账户明细dto")
public class HuifuWalletAccountDetailDto extends HuifuWalletAccountDetail {
    @ApiModelProperty(value = "账户号")
    private String walletAccountNo;

    @ApiModelProperty(value = "开始日期")
    private String startDate;

    @ApiModelProperty(value = "结束日期")
    private String endDate;

    @ApiModelProperty(value = "是否隐藏确认")
    private String isHideCheck;

    /*
     如果订单下穿表示查询明细时要关联对应订单检索账务流水号是否存在
     */
    @ApiModelProperty(value = "是否订单下穿")
    private Integer isOrderUnder = 0;

    @ApiModelProperty(value = "每页条数")
    private Integer pageSize;// 每页条数

    @ApiModelProperty(value = "第几页")
    private Integer pageNumber;// 第几页
}
