package com.zbkj.common.response;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * description: 业绩账单详情 response对象
 * author : linchunpeng
 * date : 2023/8/3
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BcxSettleBillDetailResponse对象", description = "业绩账单详情 response对象")
public class BcxSettleBillDetailResponse implements Serializable {

    @ApiModelProperty(value = "业绩账单id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "账期，yyyy-MM")
    private String billPeriod;

    @ApiModelProperty(value = "订单总数量")
    private Integer orderCount;

    @ApiModelProperty(value = "订单总金额")
    private BigDecimal orderTotalPrice;

    @ApiModelProperty(value = "佣金总金额")
    private BigDecimal brokerageTotalPrice;

    @ApiModelProperty(value = "佣金已结算总金额")
    private BigDecimal brokerageSettleTotalPrice;

    @ApiModelProperty(value = "结算状态：1待结算，2部分结算，3已结算")
    private Integer settleStatus;

    @ApiModelProperty(value = "账单生成时间")
    private Date createTime;



    @ApiModelProperty(value = "关联id：渠道表id，部门表id，部门成员表id，用户表id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long belongId;

    @ApiModelProperty(value = "关联类型：1渠道表，2部门表，3部门成员表，4用户表-分销商，5用户表-分销员")
    private Integer belongType;

    @ApiModelProperty(value = "结算对象")
    private String settleName;

}