package com.zbkj.common.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * description：设置商品是否开启分销request对象
 * author：linchunpeng
 * date：2023/8/4
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BcxSetProductBrokerageRequest对象", description = "设置商品是否开启分销request对象")
public class BcxSetProductBrokerageRequest {

    @ApiModelProperty(value = "商品id列表")
    @NotEmpty(message = "商品id列表 不能为空")
    private List<Integer> productIdList;

    @ApiModelProperty(value = "是否分销商品：0否，1是")
    @NotNull(message = "是否分销商品 不能为空")
    @Range(min = 0, max = 1, message = "是否分销商品请在0-1中选择")
    private Integer isBrokerage;

}
