package com.zbkj.common.model.huifu;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * <b> 企业钱包服务 </b>
 * @author ZXF
 * @create 2023/07/26 0026 16:47
 * @version
 * @注意事项 </b>
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("eb_huifu_wallet")
@ApiModel(value="HuifuWallet对象", description="企业钱包服务")
public class HuifuWallet implements Serializable {

    @ApiModelProperty(value = "id")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;
    @ApiModelProperty(value = "用户联合ID")
    private String uniId;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    /**
     * 是否完成开通
     */
    @ApiModelProperty(value = "是否完成开通")
    private String isCompleteOpen;

    /**
     * 完成开通时间
     */
    @ApiModelProperty(value = "完成开通时间")
    private Date openTime;

    /**
     * 合作协议url
     */
    @ApiModelProperty(value = "合作协议url")
    private String cooperateTreatyUrl;
    @ApiModelProperty(value = "支付通道")
    private String payChannel;

}