package com.zbkj.common.model.bcx;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import java.io.Serializable;
import java.util.Date;

/**
 * 主订单关系表
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
@TableName("bcx_order_relation")
@ApiModel(value = "BcxOrderRelation对象", description = "主订单关系表")
public class BcxOrderRelation implements Serializable {
    private static final long serialVersionUID=1L;

    @ApiModelProperty(value = "订单关系id")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "订单号：如果该值与主订单号一样，则该订单为主订单，否则为副订单")
    private String orderNo;

    @ApiModelProperty(value = "主订单号")
    private String masterOrderNo;
}
