package com.zbkj.common.dto;

import com.zbkj.common.model.huifu.HuifuWalletTrade;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;


/**
 * <b> 企业钱包账户交易dto </b>
 * @author ZXF
 * @create 2023/07/31 0031 11:21
 * @version
 * @注意事项 </b>
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="HuifuWalletTradeDto", description="企业钱包账户交易dto")
public class HuifuWalletTradeDto extends HuifuWalletTrade {

    @ApiModelProperty(value = "交易流水号")
    private String tradeFlowNo;

    @ApiModelProperty(value = "开始日期")
    private String startDate;

    @ApiModelProperty(value = "结束日期")
    private String endDate;

    @ApiModelProperty(value = "账户名称")
    private String accountName;

    @ApiModelProperty(value = "资金流向")
    private String fundFlowType;

    @ApiModelProperty(value = "银行交易类型")
    private String bankTradeType;

    @ApiModelProperty(value = "每页条数")
    private Integer pageSize;// 每页条数
    @ApiModelProperty(value = "第几页")
    private Integer pageNumber;// 第几页
    @ApiModelProperty(value = "支付通道")
    private String payChannel;
}
