package com.zbkj.common.dto;

import com.zbkj.common.model.huifu.HuifuWalletBusi;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * <b> 钱包账户dto </b>
 * @author ZXF
 * @create 2023/07/31 0031 11:21
 * @version
 * @注意事项 </b>
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="HuifuWalletBusiDto", description="钱包业务入驻dto")
public class HuifuWalletBusiDto extends HuifuWalletBusi {

    @ApiModelProperty(value = "账户状态")
    private String accountStatus;

    @ApiModelProperty(value = "银行名称")
    private String bankName;

    @ApiModelProperty(value = "开始日期")
    private String startDate;

    @ApiModelProperty(value = "结束日期")
    private String endDate;

    @ApiModelProperty(value = "金额")
    private BigDecimal amount;

    @ApiModelProperty(value = "充值前端回调页面")
    private String callfrontUrl;

    @ApiModelProperty(value = "订单号")
    private String orderId;

    @ApiModelProperty(value = "用户联合ID")
    private String uniId;
}
