package com.zbkj.common.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;

/**
 * <b> 汇付C端聚合正扫产品配置 </b>
 * @author ZXF
 * @create 2023/08/25 0025 15:29
 * @version
 * @注意事项 </b>
 */
@Data
public class GoodsDetail implements Serializable {
    @ApiModelProperty(value = "商品编码")
    private String goods_id;
    @ApiModelProperty(value = "商品名称")
    private String goods_name;
    @ApiModelProperty(value = "商品单价(元)")
    private BigDecimal price;
    @ApiModelProperty(value = "商品数量")
    private int quantity;

    public String getPrice() {
        return new DecimalFormat("#0.00").format(price);
    }
}
