/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Region;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import com.zbkj.common.config.CrmebConfig;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.system.SystemAttachment;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.UploadUtil;
import com.zbkj.common.vo.CloudVo;
import com.zbkj.common.vo.FileResultVo;
import com.zbkj.service.service.CosService;
import com.zbkj.service.service.JdCloudService;
import com.zbkj.service.service.OssService;
import com.zbkj.service.service.QiNiuService;
import com.zbkj.service.service.SystemAttachmentService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.SystemRoleService;
import com.zbkj.service.service.UploadService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import sun.misc.BASE64Decoder;

@Service
public class UploadServiceImpl
implements UploadService {
    private static final Logger logger = LoggerFactory.getLogger(UploadServiceImpl.class);
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private SystemAttachmentService systemAttachmentService;
    @Autowired
    private QiNiuService qiNiuService;
    @Autowired
    private OssService ossService;
    @Autowired
    private CosService cosService;
    @Autowired
    private CrmebConfig crmebConfig;
    @Autowired
    private SystemRoleService systemRoleService;
    @Autowired
    private JdCloudService jdCloudService;

    @Override
    public FileResultVo imageUpload(MultipartFile multipartFile, String model, Integer pid) {
        Integer ownerId = this.systemRoleService.getOwnerByCurrentAdmin();
        FileResultVo fileResultVo = new FileResultVo();
        try {
            fileResultVo = this.commonUpload(multipartFile, model, pid, "crmebimage", ownerId);
        }
        catch (IOException e) {
            logger.error("\u56fe\u7247\u4e0a\u4f20IO\u5f02\u5e38\uff0c{}", (Object)e.getMessage());
            throw new CrmebException("\u56fe\u7247\u4e0a\u4f20 IO\u5f02\u5e38");
        }
        return fileResultVo;
    }

    @Override
    public FileResultVo imageUpload(MultipartFile multipartFile, String model, Integer pid, Integer ownerId) {
        logger.error("\u56fe\u7247\u4e0a\u4f20\u8c03\u7528MultipartFile\uff1aname = {}, size = {}, contentType = {}, OriginalFileName = {}", new Object[]{multipartFile.getName(), multipartFile.getSize(), multipartFile.getContentType(), multipartFile.getOriginalFilename()});
        FileResultVo fileResultVo = new FileResultVo();
        try {
            fileResultVo = this.commonUpload(multipartFile, model, pid, "crmebimage", ownerId);
        }
        catch (IOException e) {
            logger.error("\u56fe\u7247\u4e0a\u4f20IO\u5f02\u5e38\uff0c{}", (Object)e.getMessage());
            throw new CrmebException("\u56fe\u7247\u4e0a\u4f20 IO\u5f02\u5e38");
        }
        return fileResultVo;
    }

    @Override
    public FileResultVo fileUpload(MultipartFile multipartFile, String model, Integer pid) {
        Integer ownerId = this.systemRoleService.getOwnerByCurrentAdmin();
        FileResultVo fileResultVo = new FileResultVo();
        try {
            fileResultVo = this.commonUpload(multipartFile, model, pid, "crmebimage", ownerId);
        }
        catch (IOException e) {
            logger.error("\u6587\u4ef6\u4e0a\u4f20IO\u5f02\u5e38\uff0c{}", (Object)e.getMessage());
            throw new CrmebException("\u6587\u4ef6\u4e0a\u4f20 IO\u5f02\u5e38");
        }
        return fileResultVo;
    }

    @Override
    public FileResultVo fileUpload(MultipartFile multipartFile, String model, Integer pid, Integer ownerId) {
        FileResultVo fileResultVo = new FileResultVo();
        try {
            fileResultVo = this.commonUpload(multipartFile, model, pid, "crmebimage", ownerId);
        }
        catch (IOException e) {
            logger.error("\u6587\u4ef6\u4e0a\u4f20IO\u5f02\u5e38\uff0c{}", (Object)e.getMessage());
            throw new CrmebException("\u6587\u4ef6\u4e0a\u4f20 IO\u5f02\u5e38");
        }
        return fileResultVo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileResultVo base64Upload(String base64, String model, Integer pid) {
        String rootPath = this.crmebConfig.getImagePath().trim();
        String modelPath = "public/" + model + "/";
        String type = "crmebimage/";
        String newFileName = UploadUtil.fileName((String)"jpg");
        String webPath = type + modelPath + CrmebDateUtil.nowDate((String)"yyyy/MM/dd") + "/";
        String destPath = FilenameUtils.separatorsToSystem((String)(rootPath + webPath)) + newFileName;
        File file = null;
        OutputStream out = null;
        try {
            file = UploadUtil.createFile((String)destPath);
            base64 = base64.substring(base64.indexOf(",", 1) + 1);
            BASE64Decoder d = new BASE64Decoder();
            byte[] imgbytes = d.decodeBuffer(base64);
            for (int i = 0; i < imgbytes.length; ++i) {
                if (imgbytes[i] >= 0) continue;
                int n = i;
                imgbytes[n] = (byte)(imgbytes[n] + 256);
            }
            logger.error("base64\u56fe\u7247\u5730\u5740\uff1a=========================================================================" + destPath);
            out = new FileOutputStream(file);
            out.write(imgbytes);
            out.flush();
        }
        catch (IOException e) {
            logger.error("base64\u8f6c\u56fe\u7247\u5f02\u5e38", (Throwable)e);
            throw new CrmebException("base64\u8f6c\u56fe\u7247\u5f02\u5e38:" + e);
        }
        finally {
            try {
                assert (out != null);
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("\u5173\u95edOutputStream\u6d41\u5f02\u5e38");
            }
        }
        FileResultVo resultFile = new FileResultVo();
        resultFile.setFileSize(Long.valueOf(file.length()));
        resultFile.setFileName(newFileName);
        resultFile.setExtName("jpg");
        resultFile.setUrl(webPath + newFileName);
        resultFile.setType("jpg");
        SystemAttachment systemAttachment = new SystemAttachment();
        systemAttachment.setName(resultFile.getFileName());
        systemAttachment.setSattDir(resultFile.getUrl());
        systemAttachment.setAttSize(resultFile.getFileSize().toString());
        systemAttachment.setAttType(resultFile.getType());
        systemAttachment.setImageType(Integer.valueOf(1));
        systemAttachment.setPid(pid);
        systemAttachment.setOwner(null);
        String uploadType = this.systemConfigService.getValueByKeyException("uploadType");
        Integer uploadTypeInt = Integer.parseInt(uploadType);
        if (uploadTypeInt.equals(1)) {
            this.systemAttachmentService.save(systemAttachment);
            return resultFile;
        }
        CloudVo cloudVo = new CloudVo();
        String fileIsSave = this.systemConfigService.getValueByKeyException("file_is_save");
        switch (uploadTypeInt) {
            case 2: {
                systemAttachment.setImageType(Integer.valueOf(2));
                cloudVo.setDomain(this.systemConfigService.getValueByKeyException("qnUploadUrl"));
                cloudVo.setAccessKey(this.systemConfigService.getValueByKeyException("qnAccessKey"));
                cloudVo.setSecretKey(this.systemConfigService.getValueByKeyException("qnSecretKey"));
                cloudVo.setBucketName(this.systemConfigService.getValueByKeyException("qnStorageName"));
                cloudVo.setRegion(this.systemConfigService.getValueByKeyException("qnStorageRegion"));
                try {
                    Configuration cfg = new Configuration(Region.huadong());
                    if (cloudVo.getRegion().equals("huabei")) {
                        cfg = new Configuration(Region.huabei());
                    }
                    if (cloudVo.getRegion().equals("huanan")) {
                        cfg = new Configuration(Region.huanan());
                    }
                    if (cloudVo.getRegion().equals("beimei")) {
                        cfg = new Configuration(Region.beimei());
                    }
                    if (cloudVo.getRegion().equals("dongnanya")) {
                        cfg = new Configuration(Region.xinjiapo());
                    }
                    UploadManager uploadManager = new UploadManager(cfg);
                    Auth auth = Auth.create((String)cloudVo.getAccessKey(), (String)cloudVo.getSecretKey());
                    String upToken = auth.uploadToken(cloudVo.getBucketName());
                    String webPathQn = this.crmebConfig.getImagePath();
                    logger.info("AsyncServiceImpl.qCloud.id " + systemAttachment.getAttId());
                    this.qiNiuService.uploadFile(uploadManager, upToken, systemAttachment.getSattDir(), webPathQn + "/" + systemAttachment.getSattDir(), file);
                }
                catch (Exception e) {
                    logger.error("AsyncServiceImpl.qCloud.fail " + e.getMessage());
                }
                break;
            }
            case 3: {
                systemAttachment.setImageType(Integer.valueOf(3));
                cloudVo.setDomain(this.systemConfigService.getValueByKeyException("alUploadUrl"));
                cloudVo.setAccessKey(this.systemConfigService.getValueByKeyException("alAccessKey"));
                cloudVo.setSecretKey(this.systemConfigService.getValueByKeyException("alSecretKey"));
                cloudVo.setBucketName(this.systemConfigService.getValueByKeyException("alStorageName"));
                cloudVo.setRegion(this.systemConfigService.getValueByKeyException("alStorageRegion"));
                try {
                    String webPathAl = this.crmebConfig.getImagePath();
                    logger.info("AsyncServiceImpl.oss.id " + systemAttachment.getAttId());
                    this.ossService.upload(cloudVo, systemAttachment.getSattDir(), webPathAl + "/" + systemAttachment.getSattDir(), file);
                }
                catch (Exception e) {
                    logger.error("AsyncServiceImpl.oss fail " + e.getMessage());
                }
                break;
            }
            case 4: {
                systemAttachment.setImageType(Integer.valueOf(4));
                cloudVo.setDomain(this.systemConfigService.getValueByKeyException("txUploadUrl"));
                cloudVo.setAccessKey(this.systemConfigService.getValueByKeyException("txAccessKey"));
                cloudVo.setSecretKey(this.systemConfigService.getValueByKeyException("txSecretKey"));
                cloudVo.setBucketName(this.systemConfigService.getValueByKeyException("txStorageName"));
                cloudVo.setRegion(this.systemConfigService.getValueByKeyException("txStorageRegion"));
                BasicCOSCredentials cred = new BasicCOSCredentials(cloudVo.getAccessKey(), cloudVo.getSecretKey());
                ClientConfig clientConfig = new ClientConfig(new com.qcloud.cos.region.Region(cloudVo.getRegion()));
                COSClient cosClient = new COSClient((COSCredentials)cred, clientConfig);
                try {
                    String webPathTx = this.crmebConfig.getImagePath();
                    logger.info("AsyncServiceImpl.cos.id " + systemAttachment.getAttId());
                    this.cosService.uploadFile(cloudVo, systemAttachment.getSattDir(), webPathTx + "/" + systemAttachment.getSattDir(), systemAttachment.getAttId(), cosClient);
                    break;
                }
                catch (Exception e) {
                    logger.error("AsyncServiceImpl.cos.fail " + e.getMessage());
                    break;
                }
                finally {
                    cosClient.shutdown();
                }
            }
            case 5: {
                systemAttachment.setImageType(Integer.valueOf(5));
                String bucket = this.systemConfigService.getValueByKeyException("jdBucketName");
                try {
                    String webPathTx = this.crmebConfig.getImagePath();
                    this.jdCloudService.uploadFile(systemAttachment.getSattDir(), webPathTx + "/" + systemAttachment.getSattDir(), bucket);
                    logger.info("AsyncServiceImpl.cos.id " + systemAttachment.getAttId());
                    break;
                }
                catch (Exception e) {
                    logger.error("AsyncServiceImpl.cos.fail " + e.getMessage());
                }
            }
        }
        this.systemAttachmentService.save(systemAttachment);
        if (!fileIsSave.equals("1")) {
            file.delete();
        }
        return resultFile;
    }

    private String uploadValidate(String fileName, float fileSize, String fileType, String contentType) {
        String extStr;
        String extName = FilenameUtils.getExtension((String)fileName).toLowerCase();
        if (StrUtil.isEmpty((CharSequence)extName)) {
            if (StrUtil.isNotBlank((CharSequence)contentType)) {
                extName = contentType.split("/")[1];
            } else {
                throw new RuntimeException("\u6587\u4ef6\u7c7b\u578b\u672a\u5b9a\u4e49\uff0c\u65e0\u6cd5\u4e0a\u4f20...");
            }
        }
        if (StrUtil.isNotBlank((CharSequence)(extStr = this.systemConfigService.getValueByKey(fileType.equals("uploadf") ? "file_ext_str" : "image_ext_str")))) {
            List extensionList = CrmebUtil.stringToArrayStr((String)extStr);
            if (CollUtil.isNotEmpty((Collection)extensionList)) {
                if (!extensionList.contains(extName)) {
                    throw new CrmebException("\u4e0a\u8f7d\u6587\u4ef6\u7c7b\u578b\u53ea\u80fd\u4e3a\uff1a" + extStr);
                }
            } else {
                throw new CrmebException("\u4e0a\u8f7d\u6587\u4ef6\u7c7b\u578b\u53ea\u80fd\u4e3a\uff1a" + extStr);
            }
        }
        int size = Integer.parseInt(this.systemConfigService.getValueByKey(fileType.equals("uploadf") ? "file_max_size" : "image_max_size"));
        String fs = String.format("%.2f", Float.valueOf(fileSize));
        if (fileSize > (float)size) {
            throw new CrmebException(StrUtil.format((CharSequence)"\u6700\u5927\u5141\u8bb8\u4e0a\u4f20 {} MB\u6587\u4ef6\uff0c\u5f53\u524d\u6587\u4ef6\u5927\u5c0f\u4e3a {} MB", (Object[])new Object[]{size, fs}));
        }
        return extName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileResultVo commonUpload(MultipartFile multipartFile, String model, Integer pid, String fileType, Integer owner) throws IOException {
        if (ObjectUtil.isNull((Object)multipartFile) || multipartFile.isEmpty()) {
            throw new CrmebException("\u4e0a\u8f7d\u7684\u6587\u4ef6\u5bf9\u8c61\u4e0d\u5b58\u5728...");
        }
        String fileName = multipartFile.getOriginalFilename();
        float fileSize = (float)multipartFile.getSize() / 1024.0f / 1024.0f;
        String extName = this.uploadValidate(fileName, fileSize, fileType, multipartFile.getContentType());
        if (fileName.length() > 99) {
            fileName = StrUtil.subPre((CharSequence)fileName, (int)90).concat(".").concat(extName);
        }
        String rootPath = this.crmebConfig.getImagePath().trim();
        String modelPath = "public/" + model + "/";
        String type = (fileType.equals("crmebimage") ? "crmebimage" : "uploadf") + "/";
        String newFileName = UploadUtil.fileName((String)extName);
        String webPath = type + modelPath + CrmebDateUtil.nowDate((String)"yyyy/MM/dd") + "/";
        String destPath = FilenameUtils.separatorsToSystem((String)(rootPath + webPath)) + newFileName;
        File file = UploadUtil.createFile((String)destPath);
        FileResultVo resultFile = new FileResultVo();
        resultFile.setFileSize(Long.valueOf(multipartFile.getSize()));
        resultFile.setFileName(fileName);
        resultFile.setExtName(extName);
        resultFile.setUrl(webPath + newFileName);
        resultFile.setType(multipartFile.getContentType());
        if (fileType.equals("crmebimage")) {
            resultFile.setType(resultFile.getType().replace("image/", ""));
        } else {
            resultFile.setType(resultFile.getType().replace("file/", ""));
        }
        SystemAttachment systemAttachment = new SystemAttachment();
        systemAttachment.setName(resultFile.getFileName());
        systemAttachment.setSattDir(resultFile.getUrl());
        systemAttachment.setAttSize(resultFile.getFileSize().toString());
        systemAttachment.setAttType(resultFile.getType());
        systemAttachment.setImageType(Integer.valueOf(1));
        systemAttachment.setPid(pid);
        systemAttachment.setOwner(owner);
        String uploadType = this.systemConfigService.getValueByKeyException("uploadType");
        Integer uploadTypeInt = Integer.parseInt(uploadType);
        if (uploadTypeInt.equals(1)) {
            multipartFile.transferTo(file);
            this.systemAttachmentService.save(systemAttachment);
            return resultFile;
        }
        CloudVo cloudVo = new CloudVo();
        String fileIsSave = this.systemConfigService.getValueByKeyException("file_is_save");
        multipartFile.transferTo(file);
        switch (uploadTypeInt) {
            case 2: {
                systemAttachment.setImageType(Integer.valueOf(2));
                cloudVo.setDomain(this.systemConfigService.getValueByKeyException("qnUploadUrl"));
                cloudVo.setAccessKey(this.systemConfigService.getValueByKeyException("qnAccessKey"));
                cloudVo.setSecretKey(this.systemConfigService.getValueByKeyException("qnSecretKey"));
                cloudVo.setBucketName(this.systemConfigService.getValueByKeyException("qnStorageName"));
                cloudVo.setRegion(this.systemConfigService.getValueByKeyException("qnStorageRegion"));
                try {
                    Configuration cfg = new Configuration(Region.huadong());
                    if (cloudVo.getRegion().equals("huabei")) {
                        cfg = new Configuration(Region.huabei());
                    }
                    if (cloudVo.getRegion().equals("huanan")) {
                        cfg = new Configuration(Region.huanan());
                    }
                    if (cloudVo.getRegion().equals("beimei")) {
                        cfg = new Configuration(Region.beimei());
                    }
                    if (cloudVo.getRegion().equals("dongnanya")) {
                        cfg = new Configuration(Region.xinjiapo());
                    }
                    UploadManager uploadManager = new UploadManager(cfg);
                    Auth auth = Auth.create((String)cloudVo.getAccessKey(), (String)cloudVo.getSecretKey());
                    String upToken = auth.uploadToken(cloudVo.getBucketName());
                    String webPathQn = this.crmebConfig.getImagePath();
                    logger.info("AsyncServiceImpl.qCloud.id " + systemAttachment.getAttId());
                    this.qiNiuService.uploadFile(uploadManager, upToken, systemAttachment.getSattDir(), webPathQn + "/" + systemAttachment.getSattDir(), file);
                }
                catch (Exception e) {
                    logger.error("AsyncServiceImpl.qCloud.fail " + e.getMessage());
                }
                break;
            }
            case 3: {
                systemAttachment.setImageType(Integer.valueOf(3));
                cloudVo.setDomain(this.systemConfigService.getValueByKeyException("alUploadUrl"));
                cloudVo.setAccessKey(this.systemConfigService.getValueByKeyException("alAccessKey"));
                cloudVo.setSecretKey(this.systemConfigService.getValueByKeyException("alSecretKey"));
                cloudVo.setBucketName(this.systemConfigService.getValueByKeyException("alStorageName"));
                cloudVo.setRegion(this.systemConfigService.getValueByKeyException("alStorageRegion"));
                try {
                    String webPathAl = this.crmebConfig.getImagePath();
                    logger.info("AsyncServiceImpl.oss.id " + systemAttachment.getAttId());
                    this.ossService.upload(cloudVo, systemAttachment.getSattDir(), webPathAl + "/" + systemAttachment.getSattDir(), file);
                }
                catch (Exception e) {
                    logger.error("AsyncServiceImpl.oss fail " + e.getMessage());
                }
                break;
            }
            case 4: {
                systemAttachment.setImageType(Integer.valueOf(4));
                cloudVo.setDomain(this.systemConfigService.getValueByKeyException("txUploadUrl"));
                cloudVo.setAccessKey(this.systemConfigService.getValueByKeyException("txAccessKey"));
                cloudVo.setSecretKey(this.systemConfigService.getValueByKeyException("txSecretKey"));
                cloudVo.setBucketName(this.systemConfigService.getValueByKeyException("txStorageName"));
                cloudVo.setRegion(this.systemConfigService.getValueByKeyException("txStorageRegion"));
                BasicCOSCredentials cred = new BasicCOSCredentials(cloudVo.getAccessKey(), cloudVo.getSecretKey());
                ClientConfig clientConfig = new ClientConfig(new com.qcloud.cos.region.Region(cloudVo.getRegion()));
                COSClient cosClient = new COSClient((COSCredentials)cred, clientConfig);
                try {
                    String webPathTx = this.crmebConfig.getImagePath();
                    logger.info("AsyncServiceImpl.cos.id " + systemAttachment.getAttId());
                    this.cosService.uploadFile(cloudVo, systemAttachment.getSattDir(), webPathTx + "/" + systemAttachment.getSattDir(), systemAttachment.getAttId(), cosClient);
                    break;
                }
                catch (Exception e) {
                    logger.error("AsyncServiceImpl.cos.fail " + e.getMessage());
                    break;
                }
                finally {
                    cosClient.shutdown();
                }
            }
            case 5: {
                systemAttachment.setImageType(Integer.valueOf(5));
                String bucket = this.systemConfigService.getValueByKeyException("jdBucketName");
                try {
                    String webPathTx = this.crmebConfig.getImagePath();
                    this.jdCloudService.uploadFile(systemAttachment.getSattDir(), webPathTx + "/" + systemAttachment.getSattDir(), bucket);
                    logger.info("AsyncServiceImpl.cos.id " + systemAttachment.getAttId());
                    break;
                }
                catch (Exception e) {
                    logger.error("AsyncServiceImpl.cos.fail " + e.getMessage());
                }
            }
        }
        this.systemAttachmentService.save(systemAttachment);
        if (!fileIsSave.equals("1")) {
            file.delete();
        }
        return resultFile;
    }
}

