/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.constants.ProductConstants;
import com.zbkj.common.enums.PayComponentEditStatusEnum;
import com.zbkj.common.enums.PayComponentPlatformStatusEnum;
import com.zbkj.common.enums.PayComponentStatusEnum;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.merchant.Merchant;
import com.zbkj.common.model.product.Product;
import com.zbkj.common.model.product.ProductAttr;
import com.zbkj.common.model.product.ProductAttrValue;
import com.zbkj.common.model.product.ProductDescription;
import com.zbkj.common.model.user.User;
import com.zbkj.common.model.wechat.video.PayComponentCat;
import com.zbkj.common.model.wechat.video.PayComponentDraftProduct;
import com.zbkj.common.model.wechat.video.PayComponentProduct;
import com.zbkj.common.model.wechat.video.PayComponentProductInfo;
import com.zbkj.common.model.wechat.video.PayComponentProductSku;
import com.zbkj.common.model.wechat.video.PayComponentProductSkuAttr;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.ProductAttrValueAddRequest;
import com.zbkj.common.request.wxvedio.product.ComponentProductSearchRequest;
import com.zbkj.common.request.wxvedio.product.PayComponentProductAddRequest;
import com.zbkj.common.response.ProMerchantProductResponse;
import com.zbkj.common.response.ProductAttrValueResponse;
import com.zbkj.common.response.ProductDetailResponse;
import com.zbkj.common.response.ProductMerchantResponse;
import com.zbkj.common.response.wxvideo.PayComponentProductResponse;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.common.vo.wxvedioshop.ShopSpuAddResponseVo;
import com.zbkj.common.vo.wxvedioshop.ShopSpuAddVo;
import com.zbkj.common.vo.wxvedioshop.ShopSpuCommonVo;
import com.zbkj.common.vo.wxvedioshop.ShopSpuInfoVo;
import com.zbkj.common.vo.wxvedioshop.ShopSpuSkuAttrVo;
import com.zbkj.common.vo.wxvedioshop.ShopSpuSkuVo;
import com.zbkj.common.vo.wxvedioshop.ShopSpuVo;
import com.zbkj.service.dao.PayComponentProductDao;
import com.zbkj.service.service.MerchantService;
import com.zbkj.service.service.PayComponentCatService;
import com.zbkj.service.service.PayComponentDraftProductService;
import com.zbkj.service.service.PayComponentProductInfoService;
import com.zbkj.service.service.PayComponentProductService;
import com.zbkj.service.service.PayComponentProductSkuService;
import com.zbkj.service.service.ProductAttrService;
import com.zbkj.service.service.ProductAttrValueService;
import com.zbkj.service.service.ProductService;
import com.zbkj.service.service.SystemAttachmentService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.UserMerchantCollectService;
import com.zbkj.service.service.UserService;
import com.zbkj.service.service.WechatVideoSpuService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class PayComponentProductServiceImpl
extends ServiceImpl<PayComponentProductDao, PayComponentProduct>
implements PayComponentProductService {
    private static final Logger logger = LoggerFactory.getLogger(PayComponentProductServiceImpl.class);
    @Resource
    private PayComponentProductDao dao;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private PayComponentDraftProductService draftProductService;
    @Autowired
    private WechatVideoSpuService wechatVideoSpuService;
    @Autowired
    private PayComponentProductInfoService infoService;
    @Autowired
    private PayComponentProductSkuService skuService;
    @Autowired
    private SystemAttachmentService systemAttachmentService;
    @Autowired
    private ProductAttrService productAttrService;
    @Autowired
    private ProductAttrValueService productAttrValueService;
    @Autowired
    private UserService userService;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private PayComponentCatService catService;
    @Autowired
    private MerchantService merchantService;
    @Autowired
    private UserMerchantCollectService userMerchantCollectService;
    @Autowired
    private ProductService productService;

    @Override
    public Boolean delete(Integer proId) {
        PayComponentProduct product = (PayComponentProduct)this.getById(proId);
        if (ObjectUtil.isNull((Object)product)) {
            throw new CrmebException("\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        if (product.getIsDel().booleanValue()) {
            throw new CrmebException("\u5546\u54c1\u5df2\u5220\u9664");
        }
        ShopSpuCommonVo shopSpuCommonVo = new ShopSpuCommonVo();
        shopSpuCommonVo.setOutProductId(proId.toString());
        Boolean isDel = this.wechatVideoSpuService.shopSpuDel(shopSpuCommonVo);
        if (!isDel.booleanValue()) {
            throw new CrmebException("\u81ea\u5b9a\u4e49\u4ea4\u6613\u7ec4\u4ef6\u5220\u9664\u5546\u54c1\u5931\u8d25");
        }
        product.setIsDel(Boolean.valueOf(true));
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.updateById(product);
            this.draftProductService.deleteByProId(proId);
            return Boolean.TRUE;
        });
        return execute;
    }

    @Override
    public Boolean update(PayComponentProductAddRequest addRequest) {
        ShopSpuAddResponseVo spuUpdateResponseVo;
        PayComponentProduct product = (PayComponentProduct)this.getById(addRequest.getId());
        if (ObjectUtil.isNull((Object)product) || product.getIsDel().booleanValue()) {
            throw new CrmebException("\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        PayComponentDraftProduct draftProduct = this.draftProductService.getByProId(product.getId());
        if (ObjectUtil.isNull((Object)draftProduct) || draftProduct.getIsDel().booleanValue()) {
            throw new CrmebException("\u8349\u7a3f\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        if (draftProduct.getStatus().equals(PayComponentEditStatusEnum.REVIEW_ING.getCode())) {
            ShopSpuCommonVo shopSpuCommonVo = new ShopSpuCommonVo();
            shopSpuCommonVo.setOutProductId(product.getId().toString());
            Boolean delAudit = this.wechatVideoSpuService.shopSpuDelAudit(shopSpuCommonVo);
            if (!delAudit.booleanValue()) {
                throw new CrmebException("\u5546\u54c1\u5ba1\u6838\u4e2d\uff0c\u64a4\u56de\u5ba1\u6838\u5931\u8d25!");
            }
        }
        BeanUtils.copyProperties((Object)addRequest, (Object)product);
        if (ObjectUtil.isNull((Object)addRequest.getBrandId()) || addRequest.getBrandId() == 0) {
            product.setBrandId(Integer.valueOf(2100000000));
        }
        PayComponentProductInfo productInfo = new PayComponentProductInfo();
        if (StrUtil.isNotBlank((CharSequence)addRequest.getDescInfo())) {
            productInfo.setDesc(addRequest.getDescInfo());
        }
        ArrayList attrList = CollUtil.newArrayList((Object[])new PayComponentProductSkuAttr[0]);
        ArrayList skuList = CollUtil.newArrayList((Object[])new PayComponentProductSku[0]);
        if (!addRequest.getSpecType().booleanValue()) {
            PayComponentProductSkuAttr skuAttr = new PayComponentProductSkuAttr();
            skuAttr.setAttrKey("\u8bf7\u9009\u62e9\u89c4\u683c");
            skuAttr.setAttrValue("\u9ed8\u8ba4");
            skuAttr.setIsDel(Boolean.valueOf(false));
            attrList.add(skuAttr);
            ProductAttrValueAddRequest attrValueRequest2 = (ProductAttrValueAddRequest)addRequest.getAttrValue().get(0);
            PayComponentProductSku sku2 = new PayComponentProductSku();
            sku2.setThumbImg(attrValueRequest2.getImage());
            sku2.setSalePrice(Long.valueOf(attrValueRequest2.getPrice().multiply(new BigDecimal("100")).longValue()));
            sku2.setMarketPrice(Long.valueOf(attrValueRequest2.getOtPrice().multiply(new BigDecimal("100")).longValue()));
            sku2.setStockNum(attrValueRequest2.getStock());
            sku2.setAttrList((List)attrList);
            sku2.setIsDel(Boolean.valueOf(true));
            skuList.add(sku2);
        } else {
            List valueRequestList = addRequest.getAttrValue();
            valueRequestList.forEach(attrValueRequest -> {
                PayComponentProductSku sku = new PayComponentProductSku();
                sku.setThumbImg(attrValueRequest.getImage());
                sku.setSalePrice(Long.valueOf(attrValueRequest.getPrice().multiply(new BigDecimal("100")).longValue()));
                sku.setMarketPrice(Long.valueOf(attrValueRequest.getOtPrice().multiply(new BigDecimal("100")).longValue()));
                sku.setStockNum(attrValueRequest.getStock());
                sku.setIsDel(Boolean.valueOf(true));
                String attrValueJson = attrValueRequest.getAttrValue();
                JSONObject jsonObject = JSONObject.parseObject((String)attrValueJson);
                attrList.clear();
                for (Map.Entry vo : jsonObject.entrySet()) {
                    PayComponentProductSkuAttr skuAttr = new PayComponentProductSkuAttr();
                    skuAttr.setAttrKey((String)vo.getKey());
                    skuAttr.setAttrValue(vo.getValue().toString());
                    skuAttr.setIsDel(Boolean.valueOf(false));
                    attrList.add(skuAttr);
                }
                sku.setAttrList(attrList);
                skuList.add(sku);
            });
        }
        for (PayComponentProductSku sku3 : skuList) {
            sku3.setProductId(product.getId());
        }
        boolean skuSave = this.skuService.saveBatch(skuList);
        if (!skuSave) {
            throw new CrmebException("\u7b2c\u4e00\u6b65\uff0c\u672c\u5730\u4fdd\u5b58\u5546\u54c1sku\u65f6\u9519\u8bef");
        }
        ShopSpuAddVo shopSpuAddVo = this.assembleShopSpuVo(product, skuList, productInfo);
        try {
            spuUpdateResponseVo = this.wechatVideoSpuService.shopSpuUpdate(shopSpuAddVo);
        }
        catch (Exception e2) {
            List skuIds = skuList.stream().map(PayComponentProductSku::getId).collect(Collectors.toList());
            this.skuService.removeByIds(skuIds);
            throw new CrmebException(e2.getMessage());
        }
        product.setHeadImg(this.systemAttachmentService.clearPrefix(product.getHeadImg()));
        if (StrUtil.isNotBlank((CharSequence)product.getQualificationPics())) {
            product.setQualificationPics(this.systemAttachmentService.clearPrefix(product.getQualificationPics()));
        }
        BeanUtils.copyProperties((Object)product, (Object)draftProduct, (String[])new String[]{"status", "id"});
        draftProduct.setHeadImg(this.systemAttachmentService.clearPrefix(draftProduct.getHeadImg()));
        if (StrUtil.isNotBlank((CharSequence)draftProduct.getQualificationPics())) {
            draftProduct.setQualificationPics(this.systemAttachmentService.clearPrefix(draftProduct.getQualificationPics()));
        }
        draftProduct.setProductId(product.getId());
        draftProduct.setUpdateTime(spuUpdateResponseVo.getUpdateTime());
        draftProduct.setEditStatus(PayComponentEditStatusEnum.REVIEW_ING.getCode());
        HashMap skuMap = CollUtil.newHashMap();
        spuUpdateResponseVo.getSkus().forEach(e -> skuMap.put(e.getOutSkuId(), e.getSkuId()));
        skuList.forEach(sku -> {
            sku.setComponentProductId(spuUpdateResponseVo.getProductId());
            sku.setSkuId((String)skuMap.get(sku.getId().toString()));
            sku.setIsDel(Boolean.valueOf(false));
        });
        ArrayList attrsList = CollUtil.newArrayList((Object[])new PayComponentProductSkuAttr[0]);
        skuList.forEach(e -> {
            List skuAttrs = e.getAttrList();
            skuAttrs.forEach(attr -> {
                attr.setSkuId(e.getId());
                attr.setComponentSkuId(e.getSkuId());
                attr.setIsDel(Boolean.valueOf(false));
            });
            attrsList.addAll(skuAttrs);
        });
        draftProduct.setSku(JSONArray.toJSONString((Object)skuList));
        draftProduct.setAttr(JSONArray.toJSONString((Object)addRequest.getAttr()));
        draftProduct.setAttrValue(JSONArray.toJSONString((Object)addRequest.getAttrValue()));
        draftProduct.setIsDel(Boolean.valueOf(false));
        draftProduct.setAddTime((Date)DateUtil.date());
        draftProduct.setSales(Integer.valueOf(0));
        draftProduct.setSpecType(addRequest.getSpecType());
        draftProduct.setDescInfo(addRequest.getDescInfo());
        int stock = skuList.stream().mapToInt(PayComponentProductSku::getStockNum).sum();
        draftProduct.setStock(Integer.valueOf(stock));
        boolean save = this.draftProductService.updateById(draftProduct);
        if (!save) {
            throw new CrmebException("\u7b2c\u4e09\u6b65\uff0c\u672c\u5730\u4fdd\u5b58\u8349\u7a3f\u5546\u54c1\u65f6\u9519\u8bef");
        }
        return save;
    }

    @Override
    public Boolean putonByMerchant(Integer proId) {
        PayComponentProduct product = (PayComponentProduct)this.getById(proId);
        if (ObjectUtil.isNull((Object)product)) {
            throw new CrmebException("\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        if (product.getIsDel().booleanValue()) {
            throw new CrmebException("\u5546\u54c1\u5df2\u5220\u9664");
        }
        if (!product.getStatus().equals(PayComponentStatusEnum.STATUS_PUTDOWN.getCode())) {
            throw new CrmebException("\u5546\u54c1\u53ea\u6709\u5728\u81ea\u4e3b\u4e0b\u67b6\u72b6\u6001\uff0c\u624d\u80fd\u4e0a\u67b6");
        }
        ShopSpuCommonVo shopSpuCommonVo = new ShopSpuCommonVo();
        shopSpuCommonVo.setOutProductId(proId.toString());
        shopSpuCommonVo.setNeedEditSpu(Integer.valueOf(0));
        ShopSpuVo shopSpuVo = this.wechatVideoSpuService.shopSpuGet(shopSpuCommonVo);
        if (!shopSpuVo.getStatus().equals(PayComponentStatusEnum.STATUS_PUTDOWN.getCode())) {
            throw new CrmebException("\u7ec4\u4ef6\u4e2d\u5546\u54c1\u4e0d\u5c5e\u4e8e\u81ea\u4e3b\u4e0b\u67b6\u72b6\u6001");
        }
        Boolean isListing = this.wechatVideoSpuService.shopSpuPuton(shopSpuCommonVo);
        if (!isListing.booleanValue()) {
            throw new CrmebException("\u7ec4\u4ef6\u4e2d\u5546\u54c1\u4e0a\u67b6\u5931\u8d25");
        }
        product.setStatus(PayComponentStatusEnum.STATUS_PUTON.getCode());
        product.setPlatformStatus(PayComponentPlatformStatusEnum.MERCHANT_PUTON.getCode());
        LambdaUpdateWrapper draftProductLambdaQueryWrapper = Wrappers.lambdaUpdate();
        draftProductLambdaQueryWrapper.eq(PayComponentDraftProduct::getProductId, (Object)product.getId());
        draftProductLambdaQueryWrapper.set(PayComponentDraftProduct::getPlatformStatus, (Object)PayComponentPlatformStatusEnum.MERCHANT_PUTON.getCode());
        this.draftProductService.update((Wrapper)draftProductLambdaQueryWrapper);
        return this.updateById(product);
    }

    @Override
    public Boolean putdownByMerchant(Integer proId) {
        PayComponentProduct product = (PayComponentProduct)this.getById(proId);
        if (ObjectUtil.isNull((Object)product)) {
            throw new CrmebException("\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        if (product.getIsDel().booleanValue()) {
            throw new CrmebException("\u5546\u54c1\u5df2\u5220\u9664");
        }
        if (!product.getStatus().equals(0) && !product.getStatus().equals(PayComponentStatusEnum.STATUS_PUTON.getCode())) {
            throw new CrmebException("\u5546\u54c1\u53ea\u6709\u5728\u521d\u59cb\u503c/\u4e0a\u67b6\u72b6\u6001\uff0c\u624d\u80fd\u4e0b\u67b6");
        }
        ShopSpuCommonVo shopSpuCommonVo = new ShopSpuCommonVo();
        shopSpuCommonVo.setOutProductId(proId.toString());
        shopSpuCommonVo.setNeedEditSpu(Integer.valueOf(0));
        ShopSpuVo shopSpuVo = this.wechatVideoSpuService.shopSpuGet(shopSpuCommonVo);
        if (!shopSpuVo.getStatus().equals(0) && !shopSpuVo.getStatus().equals(PayComponentStatusEnum.STATUS_PUTON.getCode())) {
            throw new CrmebException("\u7ec4\u4ef6\u4e2d\u5546\u54c1\u4e0d\u5c5e\u4e8e\u81ea\u4e3b\u4e0b\u67b6\u72b6\u6001");
        }
        Boolean isDelisting = this.wechatVideoSpuService.shopSpuPutdown(shopSpuCommonVo);
        if (!isDelisting.booleanValue()) {
            throw new CrmebException("\u7ec4\u4ef6\u4e2d\u5546\u54c1\u4e0b\u67b6\u5931\u8d25");
        }
        product.setStatus(PayComponentStatusEnum.STATUS_PUTDOWN.getCode());
        product.setPlatformStatus(PayComponentPlatformStatusEnum.MERCHANT_PUTDOWN.getCode());
        LambdaUpdateWrapper draftProductLambdaQueryWrapper = Wrappers.lambdaUpdate();
        draftProductLambdaQueryWrapper.eq(PayComponentDraftProduct::getProductId, (Object)product.getId());
        draftProductLambdaQueryWrapper.set(PayComponentDraftProduct::getPlatformStatus, (Object)PayComponentPlatformStatusEnum.MERCHANT_PUTDOWN.getCode());
        this.draftProductService.update((Wrapper)draftProductLambdaQueryWrapper);
        return this.updateById(product);
    }

    @Override
    public Boolean putdownByPlatForm(Integer proId) {
        PayComponentProduct product = (PayComponentProduct)this.getById(proId);
        if (ObjectUtil.isNull((Object)product)) {
            throw new CrmebException("\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        if (product.getIsDel().booleanValue()) {
            throw new CrmebException("\u5546\u54c1\u5df2\u5220\u9664");
        }
        if (!product.getStatus().equals(PayComponentStatusEnum.STATUS_PUTON.getCode())) {
            throw new CrmebException("\u5f53\u524d\u5546\u54c1\u975e\u4e0a\u67b6\u72b6\u6001");
        }
        ShopSpuCommonVo shopSpuCommonVo = new ShopSpuCommonVo();
        shopSpuCommonVo.setOutProductId(proId.toString());
        shopSpuCommonVo.setNeedEditSpu(Integer.valueOf(0));
        ShopSpuVo shopSpuVo = this.wechatVideoSpuService.shopSpuGet(shopSpuCommonVo);
        if (!shopSpuVo.getStatus().equals(0) && !shopSpuVo.getStatus().equals(PayComponentStatusEnum.STATUS_PUTON.getCode())) {
            throw new CrmebException("\u7ec4\u4ef6\u4e2d\u5546\u54c1\u4e0d\u5c5e\u4e8e\u81ea\u4e3b\u4e0b\u67b6\u72b6\u6001");
        }
        Boolean isDelisting = this.wechatVideoSpuService.shopSpuPutdown(shopSpuCommonVo);
        if (!isDelisting.booleanValue()) {
            throw new CrmebException("\u7ec4\u4ef6\u4e2d\u5546\u54c1\u4e0b\u67b6\u5931\u8d25");
        }
        product.setStatus(PayComponentStatusEnum.STATUS_PUTDOWN.getCode());
        product.setPlatformStatus(PayComponentPlatformStatusEnum.PLATFORM_PUTDOWN.getCode());
        LambdaUpdateWrapper draftProductLambdaQueryWrapper = Wrappers.lambdaUpdate();
        draftProductLambdaQueryWrapper.eq(PayComponentDraftProduct::getProductId, (Object)product.getId());
        draftProductLambdaQueryWrapper.set(PayComponentDraftProduct::getPlatformStatus, (Object)PayComponentPlatformStatusEnum.PLATFORM_PUTDOWN.getCode());
        this.draftProductService.update((Wrapper)draftProductLambdaQueryWrapper);
        return this.updateById(product);
    }

    @Override
    public ProductDetailResponse getH5Detail(Integer id) {
        logger.info("\u5546\u54c1\u8be6\u60c5--\u300bgetH5Detail:id={}", (Object)id);
        PayComponentProduct product = (PayComponentProduct)this.getById(id);
        if (ObjectUtil.isNull((Object)product) || product.getIsDel().booleanValue()) {
            throw new CrmebException("\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        if (!product.getStatus().equals(5)) {
            throw new CrmebException("\u5546\u54c1\u672a\u4e0a\u67b6");
        }
        ProductDetailResponse productDetailResponse = new ProductDetailResponse();
        Product storeProduct = new Product();
        BeanUtils.copyProperties((Object)product, (Object)storeProduct);
        List imageList = JSONArray.parseArray((String)product.getHeadImg(), String.class);
        storeProduct.setImage((String)imageList.get(0));
        storeProduct.setSliderImage(product.getHeadImg());
        storeProduct.setName(product.getTitle());
        List<PayComponentProductSku> skuList = this.skuService.getListByProId(product.getId());
        Long price = skuList.stream().map(PayComponentProductSku::getSalePrice).distinct().min(Long::compare).get();
        storeProduct.setPrice(new BigDecimal(price).divide(new BigDecimal("100"), 2, RoundingMode.DOWN));
        Long otPrice = skuList.stream().map(PayComponentProductSku::getMarketPrice).distinct().min(Long::compare).get();
        storeProduct.setOtPrice(new BigDecimal(otPrice).divide(new BigDecimal("100"), 2, RoundingMode.DOWN));
        PayComponentProductInfo productInfo = this.infoService.getByProId(id);
        if (ObjectUtil.isNotNull((Object)productInfo)) {
            ProductDescription productDescription = new ProductDescription();
            productDescription.setDescription(productInfo.getDesc());
            productDescription.setProductId(productInfo.getProductId());
            productDescription.setDescOrder(Integer.valueOf(1));
            productDescription.setName("\u5546\u54c1\u8be6\u60c5");
            productDescription.setType(Integer.valueOf(0));
            productDescription.setIsShow(Boolean.valueOf(true));
            storeProduct.setContents((List)CollUtil.newArrayList((Object[])new ProductDescription[]{productDescription}));
        }
        productDetailResponse.setProductInfo(storeProduct);
        ProductAttr spaPram = new ProductAttr();
        spaPram.setProductId(product.getId()).setType(ProductConstants.PRODUCT_TYPE_COMPONENT);
        List<ProductAttr> attrList = this.productAttrService.getListByProductIdAndType(product.getId(), ProductConstants.PRODUCT_TYPE_COMPONENT);
        productDetailResponse.setProductAttr(attrList);
        HashMap skuMap = CollUtil.newHashMap();
        ProductAttrValue spavPram = new ProductAttrValue();
        spavPram.setProductId(id).setType(ProductConstants.PRODUCT_TYPE_COMPONENT);
        List<ProductAttrValue> storeProductAttrValues = this.productAttrValueService.getListByProductIdAndType(id, ProductConstants.PRODUCT_TYPE_COMPONENT);
        for (ProductAttrValue storeProductAttrValue : storeProductAttrValues) {
            ProductAttrValueResponse atr = new ProductAttrValueResponse();
            BeanUtils.copyProperties((Object)storeProductAttrValue, (Object)atr);
            skuMap.put(atr.getSku(), atr);
        }
        productDetailResponse.setProductValue(skuMap);
        Merchant merchant = (Merchant)this.merchantService.getById(product.getMerId());
        ProductMerchantResponse merchantResponse = new ProductMerchantResponse();
        BeanUtils.copyProperties((Object)merchant, (Object)merchantResponse);
        merchantResponse.setCollectNum(this.userMerchantCollectService.getCountByMerId(merchant.getId()));
        List<ProMerchantProductResponse> merchantProductResponseList = this.productService.getRecommendedProductsByMerId(merchant.getId(), 4);
        merchantResponse.setProList(merchantProductResponseList);
        productDetailResponse.setMerchantInfo(merchantResponse);
        User user = this.userService.getInfo();
        if (ObjectUtil.isNotNull((Object)user)) {
            user = this.userService.getInfo();
        } else {
            productDetailResponse.setUserCollect(Boolean.valueOf(false));
        }
        return productDetailResponse;
    }

    @Override
    public PageInfo<PayComponentProduct> getMerchantProductListByAfterWechatReview(ComponentProductSearchRequest request, PageParamRequest pageParamRequest) {
        SystemAdmin currentMerchantAdmin = SecurityUtil.getLoginUserVo().getUser();
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(PayComponentProduct::getIsDel, (Object)false);
        if (ObjectUtil.isNotNull((Object)request.getProId())) {
            lqw.eq(PayComponentProduct::getId, (Object)request.getProId());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getSearch())) {
            lqw.like(PayComponentProduct::getTitle, (Object)request.getSearch());
        }
        lqw.eq(PayComponentProduct::getIsDel, (Object)false);
        lqw.eq(PayComponentProduct::getEditStatus, (Object)PayComponentEditStatusEnum.REVIEW_SUCCESS.getCode());
        lqw.eq(PayComponentProduct::getMerId, (Object)currentMerchantAdmin.getMerId());
        lqw.orderByDesc(PayComponentProduct::getId);
        List productList = this.dao.selectList((Wrapper)lqw);
        productList.forEach(e -> {
            PayComponentCat componentCat = this.catService.getByThirdCatId(e.getThirdCatId());
            e.setThirdCatName(Optional.ofNullable(componentCat.getThirdCatName()).orElse(""));
        });
        return CommonPage.copyPageInfo((Page)page, (List)productList);
    }

    @Override
    public PageInfo<PayComponentProduct> getPlatformProductListByAfterWechatReview(ComponentProductSearchRequest request, PageParamRequest pageParamRequest) {
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(PayComponentProduct::getIsDel, (Object)false);
        if (ObjectUtil.isNotNull((Object)request.getProId())) {
            lqw.eq(PayComponentProduct::getId, (Object)request.getProId());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getSearch())) {
            lqw.like(PayComponentProduct::getTitle, (Object)URLUtil.decode((String)request.getSearch()));
        }
        lqw.eq(PayComponentProduct::getEditStatus, (Object)PayComponentEditStatusEnum.REVIEW_SUCCESS.getCode());
        lqw.orderByDesc(PayComponentProduct::getId);
        List productList = this.dao.selectList((Wrapper)lqw);
        productList.forEach(e -> {
            PayComponentCat componentCat = this.catService.getByThirdCatId(e.getThirdCatId());
            e.setThirdCatName(Optional.ofNullable(componentCat.getThirdCatName()).orElse(""));
        });
        return CommonPage.copyPageInfo((Page)page, (List)productList);
    }

    @Override
    public Boolean operationStock(Integer productId, Integer num, String operationType) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        if (operationType.equals("add")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"stock = stock + {}", (Object[])new Object[]{num}));
            updateWrapper.setSql(StrUtil.format((CharSequence)"sales = IF(sales<{}, 0, sales-{})", (Object[])new Object[]{num, num}));
        }
        if (operationType.equals("sub")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"stock = stock - {}", (Object[])new Object[]{num}));
            updateWrapper.setSql(StrUtil.format((CharSequence)"sales = sales + {}", (Object[])new Object[]{num}));
            updateWrapper.last(StrUtil.format((CharSequence)"and (stock - {} >= 0)", (Object[])new Object[]{num}));
        }
        updateWrapper.eq((Object)"id", (Object)productId);
        boolean update = this.update((Wrapper)updateWrapper);
        if (!update) {
            throw new CrmebException("\u66f4\u65b0\u7ec4\u4ef6\u5546\u54c1\u5e93\u5b58\u5931\u8d25\uff0c\u5546\u54c1Id = " + productId);
        }
        return update;
    }

    @Override
    public PayComponentProductResponse getInfo(Integer id) {
        PayComponentProduct product = (PayComponentProduct)this.getById(id);
        if (ObjectUtil.isNull((Object)product) || product.getIsDel().booleanValue()) {
            throw new CrmebException("\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        List<PayComponentProductSku> skuList = this.skuService.getListByProId(id);
        PayComponentProductResponse response = new PayComponentProductResponse();
        BeanUtils.copyProperties((Object)product, (Object)response);
        response.setSkuList(skuList);
        return response;
    }

    private ShopSpuAddVo assembleShopSpuVo(PayComponentProduct product, List<PayComponentProductSku> skuList, PayComponentProductInfo productInfo) {
        ShopSpuAddVo shopSpuAddVo = new ShopSpuAddVo();
        shopSpuAddVo.setOutProductId(product.getId().toString());
        shopSpuAddVo.setTitle(product.getTitle());
        shopSpuAddVo.setPath(StrUtil.format((CharSequence)"/pages/goods/goods_details/index?id={}", (Object[])new Object[]{product.getId()}));
        shopSpuAddVo.setHeadImg(CrmebUtil.stringToArrayStr((String)product.getHeadImg()));
        if (StrUtil.isNotBlank((CharSequence)product.getQualificationPics())) {
            shopSpuAddVo.setQualificationPics(CrmebUtil.stringToArrayStr((String)product.getQualificationPics()));
        }
        if (StrUtil.isNotBlank((CharSequence)productInfo.getDesc())) {
            ShopSpuInfoVo shopSpuInfoVo = new ShopSpuInfoVo();
            shopSpuInfoVo.setDesc(productInfo.getDesc());
            shopSpuAddVo.setDescInfo(shopSpuInfoVo);
        }
        shopSpuAddVo.setThirdCatId(product.getThirdCatId());
        shopSpuAddVo.setBrandId(product.getBrandId());
        List skuVoList = skuList.stream().map(sku -> {
            ShopSpuSkuVo spuSkuVo = new ShopSpuSkuVo();
            BeanUtils.copyProperties((Object)sku, (Object)spuSkuVo);
            spuSkuVo.setOutProductId(product.getId().toString());
            spuSkuVo.setOutSkuId(sku.getId().toString());
            List attrVoList = sku.getAttrList().stream().map(attr -> {
                ShopSpuSkuAttrVo shopSpuSkuAttrVo = new ShopSpuSkuAttrVo();
                BeanUtils.copyProperties((Object)attr, (Object)shopSpuSkuAttrVo);
                return shopSpuSkuAttrVo;
            }).collect(Collectors.toList());
            spuSkuVo.setSkuAttrs(attrVoList);
            return spuSkuVo;
        }).collect(Collectors.toList());
        shopSpuAddVo.setSkus(skuVoList);
        return shopSpuAddVo;
    }

    @Override
    public PayComponentProduct getByComponentProductId(Integer proId) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(PayComponentProduct::getComponentProductId, (Object)proId);
        return (PayComponentProduct)this.getOne((Wrapper)lambdaQueryWrapper);
    }
}

