/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.constants.ProductConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.product.ProductAttrValue;
import com.zbkj.service.dao.ProductAttrValueDao;
import com.zbkj.service.service.ProductAttrValueService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ProductAttrValueServiceImpl
extends ServiceImpl<ProductAttrValueDao, ProductAttrValue>
implements ProductAttrValueService {
    @Resource
    private ProductAttrValueDao dao;

    @Override
    public boolean removeByProductId(Integer productId, int type) {
        LambdaQueryWrapper lambdaQW = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)lambdaQW.eq(ProductAttrValue::getProductId, (Object)productId)).eq(ProductAttrValue::getType, (Object)type);
        return this.dao.delete((Wrapper)lambdaQW) > 0;
    }

    @Override
    public ProductAttrValue getByProductIdAndAttrId(Integer productId, Integer attrId, Integer type) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(ProductAttrValue::getProductId, (Object)productId);
        lqw.eq(ProductAttrValue::getType, (Object)type);
        lqw.eq(ProductAttrValue::getId, (Object)attrId);
        lqw.eq(ProductAttrValue::getIsDel, (Object)false);
        lqw.last(" limit 1");
        return (ProductAttrValue)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public ProductAttrValue getByIdAndProductIdAndType(Integer id, Integer productId, Integer type) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(ProductAttrValue::getId, (Object)id);
        lqw.eq(ProductAttrValue::getProductId, (Object)productId);
        lqw.eq(ProductAttrValue::getType, (Object)type);
        lqw.eq(ProductAttrValue::getIsDel, (Object)false);
        lqw.last(" limit 1");
        return (ProductAttrValue)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public Boolean operationStock(Integer id, Integer num, String operationType, Integer type, Integer version) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        if (operationType.equals("quick")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"stock = stock + {}", (Object[])new Object[]{num}));
            if (type > 0) {
                updateWrapper.setSql(StrUtil.format((CharSequence)"quota = quota + {}", (Object[])new Object[]{num}));
            }
        }
        if (operationType.equals("add")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"stock = stock + {}", (Object[])new Object[]{num}));
            updateWrapper.setSql(StrUtil.format((CharSequence)"sales = IF(sales<{}, 0, sales-{})", (Object[])new Object[]{num, num}));
            if (type > 0) {
                updateWrapper.setSql(StrUtil.format((CharSequence)"quota = quota + {}", (Object[])new Object[]{num}));
            }
        }
        if (operationType.equals("sub")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"stock = stock - {}", (Object[])new Object[]{num}));
            updateWrapper.setSql(StrUtil.format((CharSequence)"sales = sales + {}", (Object[])new Object[]{num}));
            if (type == 0 || type == 4) {
                updateWrapper.last(StrUtil.format((CharSequence)"and (stock - {} >= 0)", (Object[])new Object[]{num}));
            } else if (type > 0) {
                updateWrapper.setSql(StrUtil.format((CharSequence)"quota = quota - {}", (Object[])new Object[]{num}));
                updateWrapper.last(StrUtil.format((CharSequence)"and (quota - {} >= 0)", (Object[])new Object[]{num}));
            }
        }
        if (operationType.equals("create")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"stock = stock - {}", (Object[])new Object[]{num}));
            updateWrapper.last(StrUtil.format((CharSequence)"and (stock - {} >= 0)", (Object[])new Object[]{num}));
        }
        updateWrapper.setSql("version = version + 1");
        updateWrapper.eq((Object)"id", (Object)id);
        updateWrapper.eq((Object)"type", (Object)type);
        updateWrapper.eq((Object)"version", (Object)version);
        boolean update = this.update((Wrapper)updateWrapper);
        if (!update) {
            throw new CrmebException("\u66f4\u65b0\u5546\u54c1attrValue\u5931\u8d25\uff0cattrValueId = " + id);
        }
        return update;
    }

    @Override
    public Boolean deleteByProductIdAndType(Integer productId, Integer type) {
        LambdaUpdateWrapper luw = Wrappers.lambdaUpdate();
        luw.set(ProductAttrValue::getIsDel, (Object)true);
        luw.eq(ProductAttrValue::getProductId, (Object)productId);
        luw.eq(ProductAttrValue::getType, (Object)type);
        return this.update((Wrapper)luw);
    }

    @Override
    public List<ProductAttrValue> getListByProductIdAndType(Integer productId, Integer type) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(ProductAttrValue::getProductId, (Object)productId);
        lqw.eq(ProductAttrValue::getType, (Object)type);
        lqw.eq(ProductAttrValue::getIsDel, (Object)false);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public List<ProductAttrValue> getByProductIdAndAttrIdList(Integer productId, List<Integer> attrIdList, Integer type) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(ProductAttrValue::getProductId, (Object)productId);
        lqw.eq(ProductAttrValue::getType, (Object)type);
        lqw.in(ProductAttrValue::getId, attrIdList);
        lqw.eq(ProductAttrValue::getIsDel, (Object)false);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Boolean seckillRollBack(Integer id, Integer num, Integer sales) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.setSql(StrUtil.format((CharSequence)"stock = stock + {}", (Object[])new Object[]{num}));
        updateWrapper.setSql(StrUtil.format((CharSequence)"sales = sales + {}", (Object[])new Object[]{sales}));
        updateWrapper.setSql("version = version + 1");
        updateWrapper.eq((Object)"id", (Object)id);
        updateWrapper.eq((Object)"type", (Object)ProductConstants.PRODUCT_TYPE_NORMAL);
        boolean update = this.update((Wrapper)updateWrapper);
        if (!update) {
            throw new CrmebException("\u66f4\u65b0\u5546\u54c1attrValue\u5931\u8d25\uff0cattrValueId = " + id);
        }
        return update;
    }

    @Override
    public List<ProductAttrValue> getByBarCodes(List<String> barCodes) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.in(ProductAttrValue::getBarCode, barCodes);
        lqw.eq(ProductAttrValue::getIsDel, (Object)false);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public List<ProductAttrValue> getByIds(List<Integer> ids) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.in(ProductAttrValue::getId, ids);
        lqw.eq(ProductAttrValue::getIsDel, (Object)false);
        return this.dao.selectList((Wrapper)lqw);
    }
}

