package com.bcxin.tenant.domain.readers.dtos;

import com.bcxin.Infrastructures.enums.ApprovedStatus;
import com.bcxin.tenant.domain.entities.valueTypes.LocationValueType;
import lombok.Getter;
import lombok.Setter;
import java.util.Date;

@Getter
@Setter
public class OrganizationDto {
    private final String id;
    private final String code;
    private final String name;
    private final ApprovedStatus status;
    private final String industryCode;
    private final String institutionalCode;
    private final LocationValueType placeOfRegister;
    private final LocationValueType placeOfBusiness;
    private final Date createdTime;

    public OrganizationDto(String id,
                           String code,
                           String name,
                           ApprovedStatus status,
                           String industryCode, String institutionalCode,
                           LocationValueType placeOfRegister,
                           LocationValueType placeOfBusiness,
                           Date createdTime) {
        this.id = id;
        this.code = code;
        this.name = name;
        this.status = status;
        this.industryCode = industryCode;
        this.institutionalCode = institutionalCode;
        this.placeOfRegister = placeOfRegister;
        this.placeOfBusiness = placeOfBusiness;
        this.createdTime = createdTime;
    }
}
