package com.bcxin.tenant.domain.entities;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonFormat;

import lombok.Data;

/**
 * @description 薪资组
 */
@Entity
@Data
@Table(name="salary_group")
public class SalaryGroup implements Serializable {


    @Id
    /**
    * id
    */
    @Column(name="id")
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;

    /**
    * 薪资组名称 
    */
    @Column(name="group_name")
    private String groupName;

    /**
    * 算薪人员 
    */
    @Column(name="pay_emp")
    private String payEmp;

    /**
    * 排除人员 
    */
    @Column(name="exclude_emp")
    private String excludeEmp;

    /**
    * 计薪周期从当月的
    */
    @Column(name="cycle_from")
    private String cycleFrom;

    /**
    * 计薪周期到当月的
    */
    @Column(name="cycle_to")
    private String  cycleTo;

    /**
    * 计薪月份 1 当月 2 次月
    */
    @Column(name="month")
    private String month;
    /**
    * 计薪月份 1 当月 2 次月
    */
    @Column(name="month_type")
    private Integer monthType;

    /**
    * 发薪日 1 当月 2 次月
    */
    @Column(name="pay_moth")
    private String payMoth;

    /**
    * 发薪日 1-12号
    */
    @Column(name="pay_day")
    private Integer payDay;

    /**
    * 日标准计薪时长 小时/ 天
    */
    @Column(name="payroll_hour")
    private Integer payrollHour;

    /**
    * 备注 
    */
    @Column(name="remark")
    private String remark;

    /**
    * 配薪方式 1 模板 2 复制已有薪资组规则 3 导入薪资规则
    */
    @Column(name="pay_way")
    private String payWay;

    /**
    * 薪资规则 json 字段{ } 
    */
    @Column(name="pay_rule")
    private String payRule;

    /**
    * 状态 0草稿 1生效
    */
    @Column(name="state")
    private Integer state;
    
    /**
     * 组织ID
     */
    @Column(name="org_id")
    private String orgId;
    /**
     * 司日历
     */
    @Column(name="calendar")
    private String calendar;
    
    /**
    * 算薪状态 
    */
    @Column(name="compute_state")
    private int computeState;
    /**
     * 锁定状态  0 未锁定（默认）  1锁定
     */
    @Column(name="lock_state")
    private Integer lockState;
    /**
    * 锁定时间
    */
    @Column(name="lock_time")
//    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private Date lockTime;

    /**
    * 创建时间
    */
    @Column(name="create_time", insertable = false)
    private Date createTime;

    /**
    * 更改时间
    */
    @Column(name="update_time", updatable = false)
    private Date updateTime;
    
    

    public SalaryGroup() {
    }

}
