/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.commands.organizations;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.util.StringUtils;

public class RegisterCompanyCommand
extends CommandAbstract {
    @NotEmpty
    private final String institutionalCode;
    @NotEmpty
    private final String industryCode;
    @NotEmpty
    private final String unifySocialCreditCode;
    @NotEmpty
    private final String unifySocialCreditCodeFile;
    @NotEmpty
    private final String name;
    @NotNull
    private final LocationCommandItem placeOfRegister;
    @NotNull
    private final LocationCommandItem placeOfBusiness;
    @NotNull
    private final ContactCommandItem administrator;
    @NotNull
    private final ContactCommandItem generalManager;
    @NotNull
    private final ContactCommandItem deputyGeneralManager;

    public void validate() {
        if (this.getAdministrator() == null) {
            throw new BadTenantException("\u7ba1\u7406\u5458\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (this.getGeneralManager() == null) {
            throw new BadTenantException("\u603b\u7ecf\u7406\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (this.getDeputyGeneralManager() == null) {
            throw new BadTenantException("\u526f\u603b\u7ecf\u7406\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (!StringUtils.hasLength((String)this.getInstitutionalCode())) {
            throw new BadTenantException("\u884c\u4e1a\u7c7b\u578b!");
        }
        if (!StringUtils.hasLength((String)this.getIndustryCode())) {
            throw new BadTenantException("\u673a\u6784\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (!StringUtils.hasLength((String)this.getUnifySocialCreditCode())) {
            throw new BadTenantException("\u7ec4\u7ec7\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (!StringUtils.hasLength((String)this.getUnifySocialCreditCodeFile())) {
            throw new BadTenantException("\u7ec4\u7ec7\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u626b\u63cf\u4ef6\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (!StringUtils.hasLength((String)this.getName())) {
            throw new BadTenantException("\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        this.validateLocation(this.getPlaceOfRegister(), "\u6ce8\u518c\u5730");
        this.validateLocation(this.getPlaceOfBusiness(), "\u7ecf\u8425\u5730");
    }

    public RegisterCompanyCommand(String institutionalCode, String industryCode, String unifySocialCreditCode, String unifySocialCreditCodeFile, String name, LocationCommandItem placeOfRegister, LocationCommandItem placeOfBusiness, ContactCommandItem administrator, ContactCommandItem generalManager, ContactCommandItem deputyGeneralManager) {
        this.institutionalCode = institutionalCode;
        this.industryCode = industryCode;
        this.unifySocialCreditCode = unifySocialCreditCode;
        this.unifySocialCreditCodeFile = unifySocialCreditCodeFile;
        this.name = name;
        this.placeOfRegister = placeOfRegister;
        this.placeOfBusiness = placeOfBusiness;
        this.administrator = administrator;
        this.generalManager = generalManager;
        this.deputyGeneralManager = deputyGeneralManager;
    }

    private void validateLocation(LocationCommandItem commandItem, String category) {
        if (commandItem == null) {
            throw new BadTenantException(String.format("%s\u4e0d\u80fd\u4e3a\u7a7a!", category));
        }
        if (commandItem.getProvince() == null && !StringUtils.hasLength((String)commandItem.getProvince().getCode())) {
            throw new BadTenantException(String.format("%s\u7684\u7701\u4efd\u4e0d\u80fd\u4e3a\u7a7a!", category));
        }
        if (commandItem.getCity() == null && !StringUtils.hasLength((String)commandItem.getCity().getCode())) {
            throw new BadTenantException(String.format("%s\u7684\u57ce\u5e02\u4e0d\u80fd\u4e3a\u7a7a!", category));
        }
        if (commandItem.getDistrict() == null && !StringUtils.hasLength((String)commandItem.getDistrict().getCode())) {
            throw new BadTenantException(String.format("%s\u7684\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a!", category));
        }
        if (!StringUtils.hasLength((String)commandItem.getAddress())) {
            throw new BadTenantException(String.format("%s\u7684\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a!", category));
        }
    }

    public static RegisterCompanyCommand create(String institutionalCode, String industryCode, String unifySocialCreditCode, String unifySocialCreditCodeFile, String name, LocationCommandItem placeOfRegister, LocationCommandItem placeOfBusiness, ContactCommandItem administrator, ContactCommandItem generalManager, ContactCommandItem deputyGeneralManager) {
        return new RegisterCompanyCommand(institutionalCode, industryCode, unifySocialCreditCode, unifySocialCreditCodeFile, name, placeOfRegister, placeOfBusiness, administrator, generalManager, deputyGeneralManager);
    }

    public String getInstitutionalCode() {
        return this.institutionalCode;
    }

    public String getIndustryCode() {
        return this.industryCode;
    }

    public String getUnifySocialCreditCode() {
        return this.unifySocialCreditCode;
    }

    public String getUnifySocialCreditCodeFile() {
        return this.unifySocialCreditCodeFile;
    }

    public String getName() {
        return this.name;
    }

    public LocationCommandItem getPlaceOfRegister() {
        return this.placeOfRegister;
    }

    public LocationCommandItem getPlaceOfBusiness() {
        return this.placeOfBusiness;
    }

    public ContactCommandItem getAdministrator() {
        return this.administrator;
    }

    public ContactCommandItem getGeneralManager() {
        return this.generalManager;
    }

    public ContactCommandItem getDeputyGeneralManager() {
        return this.deputyGeneralManager;
    }

    public static class ItemValueCommandItem {
        private final String code;
        private final String name;

        public ItemValueCommandItem(String code, String name) {
            this.code = code;
            this.name = name;
        }

        public static ItemValueCommandItem create(String code, String name) {
            return new ItemValueCommandItem(code, name);
        }

        public String getCode() {
            return this.code;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class LocationCommandItem {
        private final ItemValueCommandItem province;
        private final ItemValueCommandItem city;
        private final ItemValueCommandItem district;
        private final String address;

        public LocationCommandItem(ItemValueCommandItem province, ItemValueCommandItem city, ItemValueCommandItem district, String address) {
            this.province = province;
            this.city = city;
            this.district = district;
            this.address = address;
        }

        public static LocationCommandItem create(ItemValueCommandItem province, ItemValueCommandItem city, ItemValueCommandItem district, String address) {
            return new LocationCommandItem(province, city, district, address);
        }

        public ItemValueCommandItem getProvince() {
            return this.province;
        }

        public ItemValueCommandItem getCity() {
            return this.city;
        }

        public ItemValueCommandItem getDistrict() {
            return this.district;
        }

        public String getAddress() {
            return this.address;
        }
    }

    public static class ContactCommandItem {
        @NotEmpty
        private final String name;
        @NotEmpty
        private final String telephone;
        @NotNull
        private final CredentialType credentialType;
        @NotEmpty
        private final String credentialNumber;

        public ContactCommandItem(String name, String telephone, CredentialType credentialType, String credentialNumber) {
            this.name = name;
            this.telephone = telephone;
            this.credentialType = credentialType;
            this.credentialNumber = credentialNumber;
        }

        public static ContactCommandItem create(String name, String telephone, CredentialType credentialType, String credentialNumber) {
            return new ContactCommandItem(name, telephone, credentialType, credentialNumber);
        }

        public String getName() {
            return this.name;
        }

        public String getTelephone() {
            return this.telephone;
        }

        public CredentialType getCredentialType() {
            return this.credentialType;
        }

        public String getCredentialNumber() {
            return this.credentialNumber;
        }
    }
}

