/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.enums.ApprovedStatus;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import com.bcxin.tenant.domain.entities.CompanyEntity;
import com.bcxin.tenant.domain.entities.valueTypes.ApprovedInformationValueType;
import com.bcxin.tenant.domain.entities.valueTypes.LocationValueType;
import com.bcxin.tenant.domain.events.OrganizationCreatedEvent;
import java.sql.Timestamp;
import java.time.Instant;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;

@Inheritance(strategy=InheritanceType.JOINED)
public class OrganizationEntity
extends EntityAbstract
implements IAggregate {
    @Id
    @Column(length=50)
    private String id;
    @Column(nullable=false, length=30)
    private String code;
    @Column(name="name", nullable=false)
    private String name;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="province.code", column=@Column(name="place_Of_register_province_code")), @AttributeOverride(name="province.name", column=@Column(name="place_Of_register_province_name")), @AttributeOverride(name="city.code", column=@Column(name="place_Of_register_city_code")), @AttributeOverride(name="city.name", column=@Column(name="place_Of_register_city_name")), @AttributeOverride(name="district.code", column=@Column(name="place_Of_register_district_code")), @AttributeOverride(name="district.name", column=@Column(name="place_Of_register_district_name")), @AttributeOverride(name="address", column=@Column(name="place_Of_register_address"))})
    private LocationValueType placeOfRegister;
    @Column(name="logo_path", length=500)
    private String logoPath;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="province.code", column=@Column(name="place_Of_business_province_code")), @AttributeOverride(name="province.name", column=@Column(name="place_Of_business_province_name")), @AttributeOverride(name="city.code", column=@Column(name="place_Of_business_city_code")), @AttributeOverride(name="city.name", column=@Column(name="place_Of_business_city_name")), @AttributeOverride(name="district.code", column=@Column(name="place_Of_business_district_code")), @AttributeOverride(name="district.name", column=@Column(name="place_Of_business_district_name")), @AttributeOverride(name="address", column=@Column(name="place_Of_business_address"))})
    private LocationValueType placeOfBusiness;
    @Column(name="industry_code")
    private String industryCode;
    @Column(name="institutional_code")
    private String institutionalCode;
    @Embedded
    @Column(name="approved_information")
    @AttributeOverrides(value={@AttributeOverride(name="status", column=@Column(name="approved_information_status")), @AttributeOverride(name="lastUpdatedTime", column=@Column(name="approved_information_last_updated_time")), @AttributeOverride(name="note", column=@Column(name="approved_information_note"))})
    private ApprovedInformationValueType approvedInformationValueType;
    @Column(name="created_time", nullable=false)
    private Timestamp createdTime;
    @Column(name="last_updated_time", nullable=true)
    private Timestamp lastUpdatedTime;
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="id", referencedColumnName="id", nullable=false)
    private CompanyEntity company;

    public void change(LocationValueType placeOfRegister, LocationValueType placeOfBusiness) {
        this.setPlaceOfRegister(placeOfRegister);
        this.setPlaceOfBusiness(placeOfBusiness);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
    }

    public void changeLogoPath(String logoPath) {
        this.setLogoPath(logoPath);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
    }

    public void approve(ApprovedStatus status, String note) {
        if (this.getApprovedInformationValueType() != null && this.getApprovedInformationValueType().getStatus() == ApprovedStatus.Passed) {
            throw new BadTenantException("\u4f01\u4e1a\u5df2\u7ecf\u5ba1\u6279\u901a\u8fc7\uff0c\u65e0\u9700\u91cd\u590d\u5ba1\u6279");
        }
        ApprovedInformationValueType approvedInformation = ApprovedInformationValueType.create(status, note);
        this.setApprovedInformationValueType(approvedInformation);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
    }

    public void upgrade(String unifySocialCreditCode, String unifySocialCreditCodeFile) {
        CompanyEntity company = this.getCompany();
        if (company == null) {
            company = CompanyEntity.create(this, unifySocialCreditCode, unifySocialCreditCodeFile);
        }
        company.change(unifySocialCreditCode, unifySocialCreditCodeFile);
        this.setCompany(company);
    }

    protected OrganizationEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    protected OrganizationEntity(String industryCode, String institutionalCode, String name) {
        this();
        this.setId(UUIDUtil.getShortUuid());
        this.setCode(UUIDUtil.getShortUuid());
        this.setInstitutionalCode(institutionalCode);
        this.setIndustryCode(industryCode);
        this.setName(name);
        this.recordEvent(OrganizationCreatedEvent.create(this, this.getName()));
    }

    public static OrganizationEntity create(String industryCode, String institutionalCode, String name) {
        OrganizationEntity organization = new OrganizationEntity(industryCode, institutionalCode, name);
        return organization;
    }

    public String getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public LocationValueType getPlaceOfRegister() {
        return this.placeOfRegister;
    }

    public String getLogoPath() {
        return this.logoPath;
    }

    public LocationValueType getPlaceOfBusiness() {
        return this.placeOfBusiness;
    }

    public String getIndustryCode() {
        return this.industryCode;
    }

    public String getInstitutionalCode() {
        return this.institutionalCode;
    }

    public ApprovedInformationValueType getApprovedInformationValueType() {
        return this.approvedInformationValueType;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public Timestamp getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public CompanyEntity getCompany() {
        return this.company;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setCode(String code) {
        this.code = code;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setPlaceOfRegister(LocationValueType placeOfRegister) {
        this.placeOfRegister = placeOfRegister;
    }

    protected void setLogoPath(String logoPath) {
        this.logoPath = logoPath;
    }

    protected void setPlaceOfBusiness(LocationValueType placeOfBusiness) {
        this.placeOfBusiness = placeOfBusiness;
    }

    protected void setIndustryCode(String industryCode) {
        this.industryCode = industryCode;
    }

    protected void setInstitutionalCode(String institutionalCode) {
        this.institutionalCode = institutionalCode;
    }

    protected void setApprovedInformationValueType(ApprovedInformationValueType approvedInformationValueType) {
        this.approvedInformationValueType = approvedInformationValueType;
    }

    protected void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    protected void setLastUpdatedTime(Timestamp lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    protected void setCompany(CompanyEntity company) {
        this.company = company;
    }
}

