/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.Infrastructures.enums.ApprovedStatus;
import com.bcxin.api.interfaces.ResponseAbstract;
import java.text.SimpleDateFormat;
import java.util.Date;

public class OrganizationResponse
extends ResponseAbstract {
    private final String id;
    private final String code;
    private final String name;
    private final String status;
    private final String industryCode;
    private final String institutionalCode;
    private final String placeOfRegister;
    private final String placeOfBusiness;
    private final String createdTime;

    public OrganizationResponse(String id, String code, String name, ApprovedStatus status, String industryCode, String institutionalCode, String placeOfRegister, String placeOfBusiness, Date createdTime) {
        this.id = id;
        this.code = code;
        this.name = name;
        if (status == null) {
            this.status = "\u5f85\u5ba1\u6279";
        } else {
            switch (status) {
                case Passed: {
                    this.status = "\u5ba1\u6279\u901a\u8fc7";
                    break;
                }
                case NoPassed: {
                    this.status = "\u4e0d\u901a\u8fc7";
                    break;
                }
                default: {
                    this.status = "\u5f85\u5ba1\u6279";
                }
            }
        }
        this.industryCode = industryCode;
        this.institutionalCode = institutionalCode;
        this.placeOfRegister = placeOfRegister;
        this.placeOfBusiness = placeOfBusiness;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.createdTime = createdTime == null ? null : dateFormat.format(createdTime);
    }

    public static OrganizationResponse create(String id, String code, String name, ApprovedStatus status, String industryCode, String institutionalCode, String placeOfRegister, String placeOfBusiness, Date createdTime) {
        return new OrganizationResponse(id, code, name, status, industryCode, institutionalCode, placeOfRegister, placeOfBusiness, createdTime);
    }

    public String getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getStatus() {
        return this.status;
    }

    public String getIndustryCode() {
        return this.industryCode;
    }

    public String getInstitutionalCode() {
        return this.institutionalCode;
    }

    public String getPlaceOfRegister() {
        return this.placeOfRegister;
    }

    public String getPlaceOfBusiness() {
        return this.placeOfBusiness;
    }

    public String getCreatedTime() {
        return this.createdTime;
    }
}

