/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.Infrastructures.enums.EmploymentStatus;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.enums.TrueFalseStatus;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.util.StringUtils;

public class ContractGetResponse
implements Serializable {
    private final String id;
    private final String name;
    private final String aName;
    private final String bName;
    private final Date beginDate;
    private final Date endDate;
    private final boolean dateLimitless;
    private final String attachment;
    private final String note;
    private final String employeeId;
    private final String employeeName;
    private final String employeeTelephone;
    private final String employeeDepartName;
    private final OccupationType employeeOccupationType;
    private final EmploymentStatus employeeStatus;

    public ContractGetResponse(String id, String name, String aName, String bName, String employeeId, String employeeName, String employeeTelephone, String employeeDepartName, OccupationType employeeOccupationType, EmploymentStatus employeeStatus, Date beginDate, Date endDate, TrueFalseStatus dateLimitless, String attachment, String note) {
        this.id = id;
        this.name = name;
        this.aName = aName;
        this.bName = bName;
        this.employeeId = employeeId;
        this.employeeName = employeeName;
        this.employeeTelephone = employeeTelephone;
        this.employeeDepartName = employeeDepartName;
        this.employeeOccupationType = employeeOccupationType;
        this.employeeStatus = employeeStatus;
        this.beginDate = beginDate;
        this.endDate = endDate;
        this.dateLimitless = dateLimitless == TrueFalseStatus.True;
        this.attachment = attachment;
        this.note = note;
    }

    public String getDateRang() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (this.getEndDate() == null) {
            return String.format("%s\u81f3\u6c38\u8fdc", dateFormat.format(this.getBeginDate()));
        }
        return String.format("%s\u81f3%s", dateFormat.format(this.getBeginDate()), dateFormat.format(this.getEndDate()));
    }

    public String getEmployeeStatusDesc() {
        if (this.getEmployeeStatus() == EmploymentStatus.OffJob) {
            return "\u79bb\u804c";
        }
        return "\u5728\u804c";
    }

    public String getContractStatusDesc() {
        if (!StringUtils.hasLength((String)this.getAttachment())) {
            return "\u5f85\u5b8c\u5584";
        }
        Date today = new Date();
        if (this.getEmployeeStatus() == EmploymentStatus.OffJob || this.getEndDate() != null && this.getEndDate().before(today)) {
            return "\u7ec8\u6b62";
        }
        if (this.getBeginDate().after(today)) {
            return "\u5f85\u751f\u6548";
        }
        return "\u751f\u6548\u4e2d";
    }

    public String getBeginDateDesc() {
        if (this.getBeginDate() == null) {
            return null;
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(this.getBeginDate());
    }

    public String getEndDateDesc() {
        if (this.getEndDate() == null) {
            return null;
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(this.getEndDate());
    }

    public static ContractGetResponse create(String id, String name, String aName, String bName, String employeeId, String employeeName, String employeeTelephone, String employeeDepartName, OccupationType employeeOccupationType, EmploymentStatus employeeStatus, Date beginDate, Date endDate, TrueFalseStatus status, String attachment, String note) {
        return new ContractGetResponse(id, name, aName, bName, employeeId, employeeName, employeeTelephone, employeeDepartName, employeeOccupationType, employeeStatus, beginDate, endDate, status, attachment, note);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getAName() {
        return this.aName;
    }

    public String getBName() {
        return this.bName;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public boolean isDateLimitless() {
        return this.dateLimitless;
    }

    public String getAttachment() {
        return this.attachment;
    }

    public String getNote() {
        return this.note;
    }

    public String getEmployeeId() {
        return this.employeeId;
    }

    public String getEmployeeName() {
        return this.employeeName;
    }

    public String getEmployeeTelephone() {
        return this.employeeTelephone;
    }

    public String getEmployeeDepartName() {
        return this.employeeDepartName;
    }

    public OccupationType getEmployeeOccupationType() {
        return this.employeeOccupationType;
    }

    public EmploymentStatus getEmployeeStatus() {
        return this.employeeStatus;
    }
}

