package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.Infrastructures.enums.*;
import com.bcxin.api.interfaces.ResponseAbstract;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;

import java.text.SimpleDateFormat;
import java.util.Date;

@ApiModel(description = "当前用户的基本信息")
@Getter
public class UserProfileGetResponse extends ResponseAbstract {
    /**
     * 租户的Id信息
     */
    @ApiModelProperty(value = "Id")
    private final String id;
    @ApiModelProperty(value = "姓名",required = true,example = "张三")
    private final String name;
    @ApiModelProperty(value = "经纬度坐标",example = "'{\"latitude\":24.607463,\"longitude\":118.052021,\"time\":\"2021-07-14 11:24:04\"}'",dataType = "String")
    private final String lonLatJson;

    @ApiModelProperty(value = "手机号码",dataType = "String")
    private final String telephone;

    @ApiModelProperty(value = "核验状态",example = "Matched",allowableValues = "None, Matched, NotMatched.")
    private final UserCheckedStatus checkedStatus;
    @ApiModelProperty(value = "实名认证状态",example = "Passed",allowableValues = "UnAuthenticated, Authenticating, Failed, Passed.")
    private final RealNameAuthenticatedStatus authenticateStatus;
    @ApiModelProperty(value = "实名认证备注",example = "实名认证结果一致通过")
    private final String authenticatedResult;

    @ApiModelProperty(value = "头像")
    private final String headPhoto;

    @ApiModelProperty(value = "性别")
    private final Sex sex;

    @ApiModelProperty(value = "民族")
    private final String nation;

    @ApiModelProperty(value = "政治面貌")
    private final String politicsStatus;

    @ApiModelProperty(value = "身高",example = "180cm")
    private final String stature;

    @ApiModelProperty(value = "兵役情况")
    private final String militaryStatus;

    @ApiModelProperty(value = "出生日期",example = "1990-01-01",dataType = "String")
    private final Date birthdate;

    @ApiModelProperty(value = "文化程度")
    private final String education;

    @ApiModelProperty(value = "户籍类型")
    private final String householdType;

    @ApiModelProperty(value = "籍贯")
    private final String nativePlace;

    @ApiModelProperty(value = "婚姻状况")
    private final String maritalStatus;

    @ApiModelProperty(value = "一寸免冠白底彩照")
    private final String oneInchColorWhitePhoto;

    @ApiModelProperty(value = "两寸免冠蓝底彩照")
    private final String twoInchColorBluePhoto;

    @ApiModelProperty(value = "设备Id")
    private final String cid;

    public UserProfileGetResponse(
            String id, String name,
            String telephone,
            String lonLatJson,
            Date birthdate,
            UserCheckedStatus checkedStatus,
            RealNameAuthenticatedStatus authenticateStatus,
            String authenticatedResult,
            String stature,
            String headPhoto,
            Sex sex, String nation,
            String politicsStatus,
            String militaryStatus,
            String education,
            String householdType,
            String nativePlace,
            String maritalStatus,
            String oneInchColorWhitePhoto,
            String twoInchColorBluePhoto,
            String cid) {
        this.id = id;
        this.name = name;
        this.lonLatJson = lonLatJson;
        this.telephone = telephone;
        this.birthdate = birthdate;
        this.checkedStatus = checkedStatus;
        this.authenticateStatus = authenticateStatus;
        this.authenticatedResult = authenticatedResult;
        this.stature = stature;
        this.headPhoto = headPhoto;
        this.sex = sex;
        this.nation = nation;
        this.politicsStatus = politicsStatus;
        this.militaryStatus = militaryStatus;
        this.education = education;
        this.householdType = householdType;
        this.nativePlace = nativePlace;
        this.maritalStatus = maritalStatus;
        this.oneInchColorWhitePhoto = oneInchColorWhitePhoto;
        this.twoInchColorBluePhoto = twoInchColorBluePhoto;
        this.cid = cid;
    }

    public static UserProfileGetResponse create(
            String id, String name,
            String telephone,
            String lonLatJson,
            Date birthdate,
            UserCheckedStatus checkedStatus,
            RealNameAuthenticatedStatus authenticateStatus,
            String authenticatedResult,
            String stature,
            UserType userType, String headPhoto,
            Sex sex, String nation,
            String politicsStatus,
            String militaryStatus,
            String education,
            String householdType,
            String nativePlace,
            String maritalStatus,
            String oneInchColorWhitePhoto,
            String twoInchColorBluePhoto,
            String cid) {
        return new UserProfileGetResponse(id, name, telephone, lonLatJson, birthdate,
                checkedStatus, authenticateStatus, authenticatedResult,
                stature,
                headPhoto, sex, nation, politicsStatus,
                militaryStatus, education, householdType, nativePlace, maritalStatus,
                oneInchColorWhitePhoto, twoInchColorBluePhoto, cid);
    }

}
