package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.Infrastructures.enums.MasterSlaveType;
import lombok.Getter;

import java.io.Serializable;
import java.util.Map;

@Getter
public class UserOrganBasicGetResponse implements Serializable {
    private final String organizationId;
    private final String employeeId;
    private final String name; // 员工姓名
    private final String employeeNo;
    private final MasterSlaveType masterSlaveType;
    private final Map<String,Object> additional;

    public UserOrganBasicGetResponse(String organizationId, String employeeId, String name,
                                     MasterSlaveType masterSlaveType,String employeeNO,Map<String,Object> additional) {
        this.organizationId = organizationId;
        this.employeeId = employeeId;
        this.name = name;
		this.employeeNo = employeeNO;
        this.masterSlaveType = masterSlaveType;
        this.additional = additional;
    }

    public static UserOrganBasicGetResponse create(String organizationId, String employeeId,String name,
                                                   MasterSlaveType masterSlaveType,String employeeNo,Map<String,Object> additional) {
        return new UserOrganBasicGetResponse(organizationId, employeeId, name, masterSlaveType,employeeNo,additional);
    }
}
