package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.Infrastructures.enums.EmploymentStatus;
import com.bcxin.Infrastructures.enums.MasterSlaveType;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.api.interfaces.ResponseAbstract;
import lombok.Getter;
import java.util.Date;

@Getter
public class MyOrganizationProfileGetResponse extends ResponseAbstract {
    private final String id;
    private final String name;
    private final String industryCode;
    private final String institutionalCode;

    /**
     * 职员的基本信息
     */
    private final String employeeId;
    private final OccupationType occupationType;
    private final EmploymentStatus status;
    private final Date hiredTime;
    private final String tenantUserId;
    private final String accessToken;
    private final boolean isMaster;

    public MyOrganizationProfileGetResponse(
            String id, String name,
            String industryCode,
            String institutionalCode,
            String employeeId,
            String tenantUserId,
            OccupationType occupationType,
            EmploymentStatus status,
            Date hiredTime,
            MasterSlaveType masterSlaveType,
            String accessToken) {
        this.id = id;
        this.name = name;
        this.industryCode = industryCode;
        this.institutionalCode = institutionalCode;
        this.employeeId = employeeId;
        this.occupationType = occupationType;
        this.status = status;
        this.hiredTime = hiredTime;
        this.tenantUserId = tenantUserId;
        /**
         * 是否为系统管理员
         */
        this.isMaster = masterSlaveType==MasterSlaveType.Master;

        this.accessToken = accessToken;
    }

    public static MyOrganizationProfileGetResponse create(
            String id, String name, String industryCode,
            String institutionalCode,
            String employeeId,
            String tenantUserId,
            OccupationType occupationType,
            EmploymentStatus status,
            Date hiredTime,
            MasterSlaveType masterSlaveType,
            String accessToken) {
        return new MyOrganizationProfileGetResponse(
                id, name, industryCode, institutionalCode,
                employeeId, tenantUserId, occupationType,
                status, hiredTime, masterSlaveType, accessToken);
    }
}
