package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.api.interfaces.ResponseAbstract;
import lombok.Getter;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;

@Getter
public class EmployeeLeaveGetResponse extends ResponseAbstract {
    private final String id;
    private final String name;
    private final String telephone;
    private final String departName;
    private final CredentialType credentialType;
    private final String credentialNumber;
    private final Date leaveDate;
    private final String leaveNote;
    private final String operatorName;
    protected final Timestamp operatedTime;

    public EmployeeLeaveGetResponse(String id, String name, String telephone,
                                    String departName, CredentialType credentialType,
                                    String credentialNumber,
                                    Date leaveDate, String leaveNote,
                                    String operatorName, Timestamp operatedTime) {
        this.id = id;
        this.name = name;
        this.telephone = telephone;
        this.departName = departName;
        this.credentialType = credentialType;
        this.credentialNumber = credentialNumber;
        this.leaveDate = leaveDate;
        this.leaveNote = leaveNote;
        this.operatorName = operatorName;
        this.operatedTime = operatedTime;
    }

    public static EmployeeLeaveGetResponse create(String id, String name, String telephone,
                                                  String departName, CredentialType credentialType,
                                                  String credentialNumber,
                                                  Date leaveDate, String leaveNote,
                                                  String operatorName, Timestamp operatedTime) {
        return new EmployeeLeaveGetResponse(id, name, telephone, departName, credentialType, credentialNumber,
                leaveDate, leaveNote, operatorName, operatedTime);
    }

    public String getLeaveDateText()
    {
        if(this.getLeaveDate()==null) {
            return null;
        }

        return new SimpleDateFormat("yyyy-MM-dd").format(this.getLeaveDate());
    }

    public String getOperatedTimeText() {
        if (this.getOperatedTime() == null) {
            return null;
        }

        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(this.getOperatedTime());
    }
}
