package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.api.interfaces.ResponseAbstract;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

@Getter
public class EmployeeDetailGetResponse extends ResponseAbstract {
    @ApiModelProperty("Id")
    private final String id;
    @ApiModelProperty("部门Id")
    private final String departId;
    @ApiModelProperty("部门名称")
    private final String departName;
    @ApiModelProperty("上级Id")
    private final String superiorId;
    @ApiModelProperty("上级名称")
    private final String superiorName;
    @ApiModelProperty("入职时间")
    private final String hiredDate;
    @ApiModelProperty("转正时间")
    private final String positiveDate;
    @ApiModelProperty("职位")
    private final String position;
    @ApiModelProperty("职业类型")
    private final OccupationType occupationType;
    private final UserDetailGetResponse userInfo;

    public EmployeeDetailGetResponse(String id,
                                     String departId,
                                     String departName,
                                     String superiorId,
                                     String superiorName,
                                     Date hiredDate, Date positiveDate,
                                     String position,
                                     OccupationType occupationType,
                                     UserDetailGetResponse userInfo) {
        this.id = id;
        this.superiorId = superiorId;
        this.superiorName = superiorName;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (hiredDate != null) {
            this.hiredDate = simpleDateFormat.format(hiredDate);
        } else {
            this.hiredDate = null;
        }

        if (positiveDate != null) {
            this.positiveDate = simpleDateFormat.format(positiveDate);
        } else {
            this.positiveDate = null;
        }

        this.position = position;
        this.occupationType = occupationType;
        this.userInfo = userInfo;
        this.departId = departId;
        this.departName = departName;
    }

    public static EmployeeDetailGetResponse create(String id,
                                                   String departId,
                                                   String departName,
                                                   String superiorId,
                                                   String superiorName,
                                                   Date hiredDate, Date positiveDate,
                                                   String position,
                                                   OccupationType occupationType,
                                                   UserDetailGetResponse userInfo) {
        return new EmployeeDetailGetResponse(id,
                departId,
                departName,
                superiorId, superiorName, hiredDate, positiveDate, position, occupationType, userInfo);
    }
}
