package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.Infrastructures.enums.EmploymentStatus;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.enums.TrueFalseStatus;
import com.bcxin.Infrastructures.utils.DateUtil;
import com.bcxin.Infrastructures.utils.StringUtil;
import lombok.Getter;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

@Getter
public class ContractGetResponse implements Serializable {
    private final String id;
    private final String name;
    private final String aName;
    private final String bName;
    private final Date beginDate;
    private final Date endDate;
    private final boolean dateLimitless;
    private final String attachment;
    private final String note;
    private final String employeeId;

    private final String employeeName;
    private final String employeeTelephone;
    private final String employeeDepartName;
    private final OccupationType employeeOccupationType;
    private final EmploymentStatus employeeStatus;


    public ContractGetResponse(String id,
                               String name,
                               String aName,
                               String bName,
                               String employeeId,
                               String employeeName, String employeeTelephone,
                               String employeeDepartName, OccupationType employeeOccupationType,
                               EmploymentStatus employeeStatus, Date beginDate, Date endDate,
                               TrueFalseStatus dateLimitless, String attachment,String note) {
        this.id = id;
        this.name = name;
        this.aName = aName;
        this.bName = bName;
        this.employeeId = employeeId;

        this.employeeName = employeeName;
        this.employeeTelephone = employeeTelephone;
        this.employeeDepartName = employeeDepartName;
        this.employeeOccupationType = employeeOccupationType;
        this.employeeStatus = employeeStatus;
        this.beginDate = beginDate;
        this.endDate = endDate;
        this.dateLimitless = dateLimitless == TrueFalseStatus.True;
        this.attachment = attachment;
        this.note = note;
    }

    public String getDateRang() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (this.getEndDate() == null) {
            return String.format("%s至永远", dateFormat.format(this.getBeginDate()));
        } else {
            return String.format("%s至%s", dateFormat.format(this.getBeginDate()), dateFormat.format(this.getEndDate()));
        }
    }

    public String getEmployeeStatusDesc() {
        if (this.getEmployeeStatus() == EmploymentStatus.OffJob) {
            return "离职";
        }

        return "在职";
    }

    public String getContractStatusDesc() {
        if (!StringUtils.hasLength(this.getAttachment())) {
            return "待完善";
        }

        Date today = new Date();
        if (this.getEmployeeStatus() == EmploymentStatus.OffJob ||
                (this.getEndDate() != null && this.getEndDate().before(today))) {
            return "终止";
        }

        if (this.getBeginDate().after(today)) {
            return "待生效";
        }

        return "生效中";
    }

    public String getBeginDateDesc() {
        if (this.getBeginDate() == null) {
            return null;
        }

        return new SimpleDateFormat("yyyy-MM-dd").format(this.getBeginDate());
    }

    public String getEndDateDesc() {
        if (this.getEndDate() == null) {
            return null;
        }

        return new SimpleDateFormat("yyyy-MM-dd").format(this.getEndDate());
    }

    public static ContractGetResponse create(String id,
                                             String name,
                                             String aName,
                                             String bName,
                                             String employeeId,
                                             String employeeName, String employeeTelephone,
                                             String employeeDepartName, OccupationType employeeOccupationType,
                                             EmploymentStatus employeeStatus, Date beginDate, Date endDate,
                                             TrueFalseStatus status, String attachment,String note) {
        return new ContractGetResponse(id,
                name,aName,bName,employeeId,
                employeeName, employeeTelephone, employeeDepartName,
                employeeOccupationType, employeeStatus, beginDate, endDate, status,
                attachment, note);
    }
}
