package com.bcxin.api.interfaces.tenants.requests.tenantUsers;

import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.api.interfaces.RequestAbstract;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;

import java.util.Date;

@Getter
public class UpdateCredentialRequest extends RequestAbstract {
    @ApiModelProperty(value = "证件类型")
    private final CredentialType credentialType;
    @ApiModelProperty(value = "姓名")
    private final String name;
    @ApiModelProperty(value = "人头像")
    private final String headPhoto;

    @ApiModelProperty(value = "证件号码")
    private final String number;

    @ApiModelProperty(value = "有效期从")
    private final Date validDateFrom;

    @ApiModelProperty(value = "有效期从")
    private final Date validDateTo;

    @ApiModelProperty(value = "身份证人像面")
    private final String frontPhoto;

    @ApiModelProperty(value = "身份证国徽面")
    private final String reversePhoto;

    @ApiModelProperty(value = "地址")
    private final String address;

    public UpdateCredentialRequest(CredentialType credentialType,
                                   String name, String headPhoto,
                                   String number, Date validDateFrom, Date validDateTo,
                                   String frontPhoto, String reversePhoto,
                                   String address) {
        this.credentialType = credentialType;
        this.name = name;
        this.headPhoto = headPhoto;
        this.number = number;
        this.validDateFrom = validDateFrom;
        this.validDateTo = validDateTo;
        this.frontPhoto = frontPhoto;
        this.reversePhoto = reversePhoto;
        this.address = address;
    }
}
