package com.bcxin.api.interfaces.tenants.requests.employees;

import lombok.Getter;

import java.io.Serializable;

@Getter
public class BatchImportEmployeeRequest implements Serializable {
    private final String name;
    private final String telephone;
    private final String departName;
    private final String occupationType;
    private final String hiredDate;
    private final String credentialType;
    private final String credentialNumber;

    public BatchImportEmployeeRequest(String name, String telephone, String departName,
                                      String occupationType, String hiredDate,
                                      String credentialType, String credentialNumber) {
        this.name = name;
        this.telephone = telephone;
        this.departName = departName;
        this.occupationType = occupationType;
        this.hiredDate = hiredDate;
        this.credentialType = credentialType;
        this.credentialNumber = credentialNumber;
    }

    public static BatchImportEmployeeRequest create(String name, String telephone, String departName,
                                                    String occupationType, String hiredDate,
                                                    String credentialType, String credentialNumber) {
        return new BatchImportEmployeeRequest(name, telephone, departName, occupationType,
                hiredDate, credentialType, credentialNumber);
    }
}
