package com.bcxin.api.interfaces.tenants.requests;

import lombok.Getter;

import java.io.Serializable;
import java.util.Collection;

@Getter
public class BatchCreateDepartAdminRequest implements Serializable {
    private final Collection<String> employeeIds;
    private final Collection<String> departIds;

    public BatchCreateDepartAdminRequest(Collection<String> employeeIds,
                                         Collection<String> departIds) {
        this.employeeIds = employeeIds;
        this.departIds = departIds;
    }

    public static BatchCreateDepartAdminRequest create(Collection<String> employeeIds,
                                                       Collection<String> departIds) {
        return new BatchCreateDepartAdminRequest(employeeIds, departIds);
    }
}
