package com.bcxin.api.interfaces.tenants;

import com.bcxin.api.interfaces.tenants.requests.tenantUsers.*;
import com.bcxin.api.interfaces.tenants.responses.MyOrganizationProfileGetResponse;
import com.bcxin.api.interfaces.tenants.responses.UserDetailGetResponse;
import com.bcxin.api.interfaces.tenants.responses.UserOrganBasicGetResponse;
import com.bcxin.api.interfaces.tenants.responses.UserProfileGetResponse;
import org.springframework.stereotype.Component;

import java.util.Collection;

@Component("userRpcProvider")
public interface UserRpcProvider {
    UserProfileGetResponse get(String id);

    Collection<MyOrganizationProfileGetResponse> getById(String id);

    UserOrganBasicGetResponse getByIdAndOrganId(String organId, String tenantUserId);

    void update(String id, UpdateTenantUserRequest request);

    void update(String id, SyncTenantUserLocationRequest request);

    void updateDeviceId(String id, String cid);

    void updateBasic(String id, UpdateBasicTenantUserRequest request);

    void updateCredential(String id, UpdateCredentialRequest request);

    void updatePhoto(String id, UpdateTenantPhotoRequest request);

    void syncWechatLabel(String id, SyncWechatLabelRequest request);

    UserDetailGetResponse getDetail(String id);

    void reRealNameAuthenticate(String id);
}
