package com.bcxin.api.interfaces.tenants;

import com.bcxin.Infrastructures.Pagination;
import com.bcxin.api.interfaces.commons.CommonImportResponse;
import com.bcxin.api.interfaces.tenants.criterias.EmployeeCriteria;
import com.bcxin.api.interfaces.tenants.criterias.EmployeeLeaveCriteria;
import com.bcxin.api.interfaces.tenants.requests.employees.*;
import com.bcxin.api.interfaces.tenants.responses.*;
import org.springframework.stereotype.Component;

import java.util.Collection;

@Component
public interface EmployeeRpcProvider {
    String create(String organizationId, EmployeeRequest request);

    void update(String organizationId, String id, UpdateEmployeeRequest request);

    Pagination<EmployeeGetResponse> find(String organizationId, EmployeeCriteria criteria);

    Collection<MyDepartImContactGetResponse> getMyImContacts(String organizationId, String tenantUserId);

    void batchMove(String organizationId, BatchMoveEmployeesRequest request);

    CommonImportResponse batchImport(String organizationId, String path, Collection<BatchImportEmployeeRequest> requests);

    void batchLeave(String organizationId, BatchLeaveEmployeeRequest request);

    void batchAssignSuperiors(String organizationId, BatchAssignEmployeeSuperiorRequest request);

    void back(String organizationId, BackEmployeeRequest request);

    Pagination<EmployeeLeaveGetResponse> findLeaves(String organizationId, EmployeeLeaveCriteria criteria);

    void batchPermissions(String organizationId, BatchPermissionRequest request);

    AppRolePermissionResponse getPermissions(String organizationId, String id);

    void clearPermissions(String organizationId, String id);

    EmployeeDetailGetResponse getByOrganIdAndId(String organizationId, String id);

    Collection<AppRolePermissionResponse> getBatchPermissions(String organizationId, Collection<String> ids);
}
